<?php if ( ! defined( 'ABSPATH' ) ) { die( 'Direct access forbidden.' ); }

class Widget_Employee_Anniversary extends WP_Widget {

	/**
	 * @internal
	 */
	function __construct() {
		
		$widget_ops = array( 'description' => __('Woffice widget to display the Employee Anniversary of the member in an elegant way.','woffice') );
		parent::__construct( false, __( '(Woffice) Employee Anniversary', 'woffice' ), $widget_ops );
	}

	/**
	 * @param array $args
	 * @param array $instance
	*/
	function widget( $args, $instance ) {

		$title = isset($instance['title']) ? $instance['title'] : __('Employee Anniversary','woffice');
		$max_limit = isset($instance['max_limit']) ? $instance['max_limit'] : 5;
		
		$data = array(
			'before_widget' => $args['before_widget'],
			'after_widget'  => $args['after_widget'],
			'max_limit'     => intval($max_limit),
			'order'  => isset($instance['order']) ? $instance['order'] : '',
			'title'         => str_replace( 'class="', 'class="widget_anniversary ',
			$args['before_title'] ) . esc_html($title) . $args['after_title'],
		);

		echo woffice_render_widget_view(WOFFICE_CORE_PATH. '/extensions/woffice-birthdays/views/view-anniversary.php', $data);
	}

	function update( $new_instance, $old_instance ) {
		return $new_instance;
	}

	function form( $instance ) {
		$instance = wp_parse_args( (array) $instance, array( 'title' => __('Employee Anniversary','woffice'),  'max_limit' => '5') );
		?>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php _e( 'Title', 'woffice' ); ?> </label>
			<input type="text" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>"
			       value="<?php echo esc_attr( $instance['title'] ); ?>" class="widefat"
			       id="<?php esc_attr( $this->get_field_id( 'title' ) ); ?>"/>
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'max_limit' ) ); ?>"><?php _e( 'Number of users', 'woffice' ); ?> </label>
			<input type="text" name="<?php echo esc_attr( $this->get_field_name( 'max_limit' ) ); ?>"
			       value="<?php echo esc_attr( $instance['max_limit'] ); ?>" class="widefat"
			       id="<?php esc_attr( $this->get_field_id( 'max_limit' ) ); ?>"/>
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id('order') ); ?>"><?php _e('Order:','woffice'); ?></label>
            <select class="widefat" name="<?php echo esc_attr( $this->get_field_name('order') ); ?>" id="<?php echo esc_attr( $this->get_field_id('order') ); ?>">
                <option value="ASC" <?php selected('ASC', (isset($instance['order']) ? $instance['order'] : null)); ?>><?php _e('ASC','woffice'); ?></option>
				<option value="DESC" <?php selected('DESC', (isset($instance['order']) ? $instance['order'] : null)); ?>><?php _e('DESC', 'woffice'); ?></option>
            </select>
		</p>
	<?php
	}

}

function woffice_employee_anniversary_register_widget() {

	register_widget( 'Widget_Employee_Anniversary' );

}
add_action( 'widgets_init', 'woffice_employee_anniversary_register_widget' );