<?php
defined( 'ABSPATH' ) || exit;
/**
 * Load js and css for events
 */
function woffice_project_files_load_scripts(){

    $enable_woffice_file_management = get_option('woffice_theme_options');

    if ( !isset($enable_woffice_file_management['enable_woffice_file_management']) || isset($enable_woffice_file_management['enable_woffice_file_management']) && !$enable_woffice_file_management['enable_woffice_file_management'] ) {
        return;
    }

    if(!is_singular('project')){
        return;
    }

    wp_enqueue_script(
        'woffice-file-manager-main',
        woffice_get_extension_uri('file-management', 'static/js/scripts.js'),
        array('jquery', 'woffice-theme-script'),
        WOFFICE_THEME_VERSION,
        true
    );

    $files_config = array(
        'ajax_url' => admin_url('admin-ajax.php'),
        'id' => get_the_ID(),
        'nonce' => wp_create_nonce('woffice-file-manager-actions'),
        'delete_message' => __('Are you sure! you want to delete this file?','woffice'),
        'file_rename_msg' => __('Please enter valid file name.','woffice'),
        'data_appender' => Woffice_Extension_File_Manager::woffice_file_manager_appender()
    );

    wp_localize_script(
        'woffice-file-manager-main',
        'WOFFICE_FILE_MANAGER',
        $files_config
    );
}

add_action( 'wp_enqueue_scripts', 'woffice_project_files_load_scripts',100);