/**
 * Main Woffice_File_Manager object
 *
 * @since 2.5.0
 * @type {{}}
 */
var Woffice_File_Manager = {
  /**
   * Initialize the Woffice's JS
   *
   * @param {jQuery} $
   */
  init: function ($) {
    "use strict";

    var self = this;

    self.$ = typeof $ === "undefined" ? jQuery : $;
    self.data =
      typeof WOFFICE_FILE_MANAGER !== "undefined" ? WOFFICE_FILE_MANAGER : {};

    /*
     * When the page is starting
     */
    self.$(window).load(function () {
      self.FileHandling.FileHandler();
      self.FileHandling.DeleteFile();
      self.FileHandling.FileRename();
      self.FileHandling.Caps();
      // self.FileHandling.WatchSelect2();
    });

    /*
     * Watchers, binding events after page load
     */

    $(document).ready(function() {
      self.FileHandling.WatchSelect2();
      self.FileHandling.Caps();
    });

    {
      self.FileHandling.Caps();
    }
  },

  /*
   * New Menu Layout
   */
  FileHandling: {
    FileHandler: function () {
      var $ = Woffice_File_Manager.$;
      var self = this;

      $(".woffice_file_manager_upload_btn").on("click", function (e) {
        e.preventDefault();
        self.FileUp();
      });

      $('.woffice-files-create').on('click',function(){
          $(this).children('.woffice-icon').toggleClass('woffice-icon-Cross');
          $('.woffice-files-upload-wrapper').slideToggle(500);
      });

      $('body').on('click','.remove_file_btn',function(){
        $(this).parents('.woffice-file-input-row').remove();
    });
    },
    FileUp: function (event) {
      var $ = Woffice_File_Manager.$;
      var self = this;
      var item_content = [];

      $('.woffice-file-input-row').each(function(i,el){
        var capabilities = $(el).find('.woffice-file-col .woffice-file-capabilities').val();
        var members = $(el).find('.woffice-file-specific-members-inp .woffice-file-specific-members').val();
        
        var newObj = {
          capabilities: capabilities,
          members: members
        };
        
        item_content.push(newObj);
      });

      var data = new FormData();
      
      data.append("action", "woffice_file_manager_upload");
      data.append("id", Woffice_File_Manager.data.id);
      data.append('nonce',Woffice_File_Manager.data.nonce);
      data.append('itemContent', JSON.stringify(item_content));

      var fileInputs = $(".woffice_file_manager_input");
      fileInputs.each(function (index, element) {
        var files = element.files;
        $.each(files, function (key, value) {
          data.append("woffice_file_manager_upload[]", value);
        });
      });
       
      $.ajax({
        type: "POST",
        url: Woffice_File_Manager.data.ajax_url,
        dataType: "JSON",
        data: data,
        cache: false,
        processData: false,
        contentType: false,
        beforeSend: function () {
          $(".woffice-file-upload-spinner").show();
        },
        success: function (data, textStatus, jqXHR) {
          $(".woffice-files-data").html("").html(data.updated_list);
          $(".woffice-file-upload-spinner").hide();
          // parent.children("input").val("");
          $(".woffice_file_manager__message").empty();
          data.uploaded_files.forEach(function (response, index) {
            if (response.response == "success") {
              self.add_message(response.error,"success");
            } else {
              self.add_message(response.error +"': " +response.error,"danger");
            }
          });
        },
        error: function (jqXHR, textStatus, errorThrown) {
          self.add_message("File upload failed: " + errorThrown, "danger");
        },
      });
    },
    DeleteFile: function () {
      var $ = Woffice_File_Manager.$;
      var self = this;
      $("body").on("click", ".woffice-remove-file", function (e) {
        e.preventDefault();
        if(!confirm(Woffice_File_Manager.data.delete_message)) {
          return;
        }
        var fileurl = $(this).siblings(".woffice-download-file").attr("href");
        var data = {
          fileurl: fileurl,
          action: "woffice_file_manager_delete",
          id: Woffice_File_Manager.data.id,
          nonce:Woffice_File_Manager.data.nonce
        };
        $.ajax({
          url: Woffice_File_Manager.data.ajax_url,
          type: "POST",
          data: data,
          cache: false,
          dataType: "json",
          success: function (data, textStatus, jqXHR) {
            $(".woffice_file_manager__message").empty();
            if (data.response == "success") {
              $(".woffice-files-data").html("").html(data.updated_list);
              $("#woffice_file_manager_upload_preview").hide();
              $("#woffice_file_manager_upload").show();
              self.add_message(data.error, "success");
            }

            if (data.response == "error") {
              self.add_message(data.error, "danger");
            }
          },
          error: function (jqXHR, textStatus, errorThrown) {
            self.add_message(textStatus, "danger");
          },
        });
      });
    },
    FileRename: function () {
      var file_to_rename = file_name = "";
      var $ = Woffice_File_Manager.$;
      var self = this;

      $("body").on("click", ".woffice-file-rename", function () {
        file_to_rename = $(this)
          .siblings(".woffice-download-file")
          .attr("href");
        var data = {
          action: "woffice_file_updater",
          id: Woffice_File_Manager.data.id,
          fileurl: file_to_rename,
          nonce:Woffice_File_Manager.data.nonce
        };
        file_to_rename = $(this)
          .siblings(".woffice-download-file")
          .attr("href");
          file_name = $(this)
          .parents(".woffice-file-list-parent")
          .find(".woffice-file-name")
          .text();
          $.ajax({
            url: Woffice_File_Manager.data.ajax_url,
            type: "POST",
            data: data,
            cache: false,
            dataType: "json",
            beforeSend: function () {
              $("#woffice-file-rename-modal .modal-body").html('');
              $("#woffice-file-rename-modal .modal-body .file-loader").removeClass('d-none');
              $("#woffice-file-rename-modal .modal-body .file-loader").after('');
              $("#woffice-file-rename-modal").modal("show");
            },
            success: function (data, textStatus, jqXHR) {
              $("#woffice-file-rename-modal .modal-body .file-loader").addClass('d-none');
              $("#woffice-file-rename-modal .modal-body").append(data);
              $('#woffice-file-rename-modal .woffice-file-specific-members').select2({ width:'100%'})
              var has_specific_members = $("#woffice-file-rename-modal .woffice-file-capabilities").val();
              
              if('specific_members' == has_specific_members) {
                $("#woffice-file-rename-modal .woffice-file-specific-members-inp").removeClass('d-none')
              } else{
                $("#woffice-file-rename-modal .woffice-file-specific-members-inp").addClass('d-none');
              }
            },
            error: function (jqXHR, textStatus, errorThrown) {
              self.add_message(textStatus, "danger");
            },
          });
        
        $("#woffice-file-rename-title").empty().text("Rename File : " + file_name);
      });

      $("body").on("click", ".woffice-file-modal-close", function () {
        $("#woffice-file-rename-modal").modal("hide");
      });

      $("body").on("click", ".woffice-file-rename-btn", function () {
        var newf_name = $("#woffice-file-rename-input").val();
        var file_caps = $('#woffice-file-rename-modal .woffice-file-capabilities').val();
        var file_auth = $('#woffice-file-rename-modal .woffice-file-specific-members').val();
        if(newf_name == '') {
          alert(Woffice_File_Manager.data.file_rename_msg);
        } else {

          var data = {
            action: "woffice_file_manager_rename_file",
            id: Woffice_File_Manager.data.id,
            old_name: $.trim(file_name),
            new_name: newf_name,
            fileurl: file_to_rename,
            file_caps: file_caps,
            file_auth: file_auth,
            nonce:Woffice_File_Manager.data.nonce
          };

          $.ajax({
            url: Woffice_File_Manager.data.ajax_url,
            type: "POST",
            data: data,
            cache: false,
            dataType: "json",
            beforeSend: function () {
              $(".woffice_file_manager__message").empty();
              $(".woffice-file-rename-spinner").show();
            },
            success: function (data, textStatus, jqXHR) {
              $(".woffice-file-rename-spinner").hide();
              $(".woffice-files-data").html("").html(data.updated_list);
              $("#woffice-file-rename-modal").modal("hide");
              $("#woffice-file-rename-input").val('');
              
              data.uploaded_files.forEach(function (response, index) {
                if (response.response == "success") {
                  self.add_message(response.error,"success");
                } else {
                  self.add_message(response.error +"': " +response.error,"danger");
                }
              });
            },
            error: function (jqXHR, textStatus, errorThrown) {
              self.add_message(data.uploaded_files[0].response.error, "danger");
            },
          });
        }
      });
    },
    add_message: function ($msg, $type) {
      var $ = Woffice_File_Manager.$;
      var self = this;
      var html = "<div class='alert alert-" + $type + "'>" + $msg + "</div>";

      $(".woffice_file_manager__message").append(html);
      $(".woffice_file_manager__message").fadeIn();
      setTimeout(function () {
        $(".woffice_file_manager__message").fadeOut("slow");
      }, 4000);
    },
    Caps: function(){
      var $ = Woffice_File_Manager.$;
      var self = this;
    
      // $('.woffice-file-specific-members').select2({ width:'100%'});
      $('.woffice-file-input-row').each(function(i,el){
        $(el).children('.woffice-file-specific-members-inp').children('.woffice-file-specific-members').select2({ width:'100%'});
      });
    
      $('body').on('change','.woffice-file-capabilities',function(){
        var item = $(this).val();
        if('specific_members' === item){
          $(this).parents('.woffice-file-col').siblings('.woffice-file-specific-members-inp').removeClass('d-none');
        }else{
          $(this).parents('.woffice-file-col').siblings('.woffice-file-specific-members-inp').addClass('d-none');
        }
      });
    },
    WatchSelect2: function(){
      var $ = Woffice_File_Manager.$;
      var self = this;
      
      $(".add_more_btn").click(function () {
        var data_appender = Woffice_File_Manager.data.data_appender;
        $(".woffice-file-input-wrapper").append(data_appender);

        Woffice_File_Manager.FileHandling.Caps();
      });
    },
  },
};

/**
 * Start it!
 *
 * We give it a jQuery object to play with
 */
Woffice_File_Manager.init(jQuery);
