<?php if ( ! defined( 'ABSPATH' ) ) { die( 'Direct access forbidden.' ); }

class Woffice_Extension_Funcfacts {

	/**
	 * @internal
	 */

	public function __construct() {
		$this->_init();
	}

	/**
	 * @internal
	 */
	public function _init() {
		$this->migrate_woffice_theme_funfacts();
	}
	
	/**
	 * CREATE FUNCTIONS TO GET THE VALUES FROM THE EXTENSION'S SETTINGS
	 * @return array
	 */
	/* THE FUNFACTS QUESTION */
	public static function woffice_get_funfacts() {
		return woffice_get_theming_option('woffice_funfacts_fields');
	}

	public function migrate_woffice_theme_funfacts() {
		
		$old_funfacts = get_option('fw_ext_settings_options:woffice-funfacts');

		$funfacts_option_default = woffice_get_theming_option('woffice_funfacts_fields');
		$woffice_funfacts_migrated = get_option('woffice_funfacts_migrated');

		if (!empty($old_funfacts)) {
			$new_facts = array();
			foreach ($old_funfacts['funfacts'] as $key => $field) {
				$new_facts['redux_repeater_data'][]['title'] = '';
				$new_facts['fact_content'][] = $field['fact_content'];
				$new_facts['fact_icon'][] = $field['fact_icon'];
			}
			if (!empty($new_facts) && isset($funfacts_option_default['fact_content']) && !empty($funfacts_option_default['fact_content'])) {
				if(class_exists('Redux') && !$woffice_funfacts_migrated){
					Redux::set_option('woffice_theme_options', 'woffice_funfacts_fields', $new_facts);
					update_option('woffice_funfacts_migrated',true);
				}
			}
		}
	}
	
}

new Woffice_Extension_Funcfacts();