<?php 

defined( 'ABSPATH' ) || exit;

/**
 * LOAD THE JAVASCRIPT FOR THE MAP
 */
function woffice_member_map_load_mapjs(){

    if (!is_admin()) {

        $enable_woffice_member_map_extenstion = get_option('woffice_theme_options');

		if (!isset($enable_woffice_member_map_extenstion['enable_woffice_member_map_extenstion']) || isset($enable_woffice_member_map_extenstion['enable_woffice_member_map_extenstion']) && !$enable_woffice_member_map_extenstion['enable_woffice_member_map_extenstion'] ) {
			return;
		}
        
        if (function_exists('bp_is_active')) {

            global $bp;
            global $post;

            // Page slug
            $post_name = (is_page()) ? get_post($post)->post_title : "nothing";
            $current_slug = sanitize_title($post_name);

            // Get the API key
            $key_option = woffice_get_theming_option('gmap_api_key');
            $key = (!empty($key_option)) ? $key_option :  "AIzaSyAyXqXI9qYLIWaD9gLErobDccodaCgHiGs";

            // Language
            $language = substr(get_locale(), 0, 2);

            if(!empty($key_option)){
                // We add the file
                wp_enqueue_script(
                    'google-maps-api-v3',
                    'https://maps.googleapis.com/maps/api/js?' . http_build_query(array(
                        'v' => '3',
                        'libraries' => 'places',
                        'language' => $language,
                        'key' => $key,
                    )),
                    true
                );
            }
        }
    }
}

add_action( 'wp_enqueue_scripts', 'woffice_member_map_load_mapjs',100);