<?php

defined( 'ABSPATH' ) || exit;


class Woffice_Extension_Woffice_Menu{

	/**
	 * @internal
	 */

	 function __construct() {
		$this->init();
	 }

     public function init() {
        
        $enable_menu_icons = get_option('woffice_theme_options');

		if ( !isset($enable_menu_icons['enable_menu_icons']) || isset($enable_menu_icons['enable_menu_icons']) && !$enable_menu_icons['enable_menu_icons'] ) {
			return;
		}
        add_filter( 'body_class', array($this,'woffice_menu_icons_class') );
        add_action( 'wp_nav_menu_item_custom_fields', array($this,'woffice_menu_item_icon'), 10, 2 );
        add_action( 'wp_update_nav_menu_item', array($this,'save_menu_item_icons'), 10, 2 );
        add_filter( 'nav_menu_item_title', array($this,'woffice_show_menu_item_icon'), 10, 2 );
        add_action( 'admin_enqueue_scripts', array($this,'enqueue_font_awesome'));
     }

     public function enqueue_font_awesome() {
        global $pagenow;
        $current_page = $pagenow;

        if($current_page == 'nav-menus.php') {
            wp_enqueue_style( 'woffice-font-fonticonbase', woffice_get_extension_uri('menus', 'assets/css/jquery.fonticonpicker.min.css'), array(), '1.0.0', 'all' );
            wp_enqueue_style( 'woffice-font-fonticonpicker', woffice_get_extension_uri('menus', 'assets/css/jquery.fonticonpicker.grey.min.css'), array(), '1.0.0', 'all' );
            wp_enqueue_style( 'font-awesome-55', woffice_get_extension_uri('menus', 'assets/css/fontawesome-all.min.css'), array(), '5.9.0', 'all' );
            wp_enqueue_script('woffice-fonticonpicker',woffice_get_extension_uri('menus', 'assets/js/jquery.fonticonpicker.min.js'),array(),true); 
        }
    }

     public function woffice_menu_icons_class($classes) {

        $classes[] = ' woffice-menu-has-icons';

        return $classes;

     }
     
     public function woffice_menu_item_icon( $item_id, $item ) {
        $woffice_menu_item_icon = get_post_meta( $item_id, '_woffice_menu_item_icon', true );
        ?>
        <div style="clear: both;">
            <span class="_woffice_menu_item_icon"><?php _e( "(Woffice) Menu Icon", 'woffice' ); ?></span><br />
            <div class="logged-input-holder">
                <input type="text" id="woffice_menu_item_icon" class="woffice_menu_item_icon"  name="woffice_menu_item_icon[<?php echo $item_id ;?>]" data-fip-value="<?php echo sanitize_text_field( $woffice_menu_item_icon ); ?>" />
                <input type="hidden" id="woffice_menu_item_icon_selected" class="woffice_menu_item_icon_selected"  name="woffice_menu_item_icon_selected[<?php echo $item_id ;?>]" value="<?php echo sanitize_text_field($woffice_menu_item_icon ); ?>" />
            </div>
        </div>
        <?php
    }

    public function save_menu_item_icons( $menu_id, $menu_item_db_id ) {
        if ( isset( $_POST['woffice_menu_item_icon'][$menu_item_db_id]  ) ) {
            $sanitized_data = sanitize_text_field( $_POST['woffice_menu_item_icon'][$menu_item_db_id] );
            update_post_meta( $menu_item_db_id, '_woffice_menu_item_icon', $sanitized_data );
        } else {
            delete_post_meta( $menu_item_db_id, '_woffice_menu_item_icon' );
        }
    }

    public function woffice_show_menu_item_icon( $title, $item ) {
        if( is_object( $item ) && isset( $item->ID ) ) {
            $woffice_menu_item_icon = get_post_meta( $item->ID, '_woffice_menu_item_icon', true );
    
            if ( ! empty( $woffice_menu_item_icon ) ) {
                $menu_title = '<i class="woffice-menu-item-icon '.esc_attr($woffice_menu_item_icon).'"></i>' . $title;
            } else {
                $menu_title = $title;
            }
        }
        return $menu_title;
    }
}

$Woffice_Extension_Woffice_Menu = new Woffice_Extension_Woffice_Menu();