<?php

defined( 'ABSPATH' ) || exit;
use Slack_Interface\Slack_Access;
/**
 * Send a notification to the slack channel
 * @param array $content
 * @return bool
 */
function woffice_slack_send_notification( $content = array() ) {

    if ( class_exists('Woffice_Extension_Woffice_Slack') && !Woffice_Extension_Woffice_Slack::is_authenticated() || empty($content) ) {
        return false;
    }

    $headers = array( 'Accept' => 'application/json' );
    $access_string = get_option('woffice_slack_access');
    $access_data = json_decode( $access_string, true );
    $Slack_Access_Data = new Slack_Access($access_data);

    $url = $Slack_Access_Data->get_incoming_webhook();

    /**
     * @link https://api.slack.com/docs/message-attachments
     */
    $defaults = array(
        'title_link' => get_site_url(),
        'pretext' => __('New notification on', 'woffice') . ' ' . get_bloginfo('name'),
    );
    $content = wp_parse_args($content, $defaults);
    $content['fallback'] = $defaults['pretext'];
    $content['color'] = woffice_get_settings_option('color_colored');
    $content['text'] = strip_tags($content['text']);

    $data = json_encode(
        array(
            'attachments' => array($content),
            'channel' => $Slack_Access_Data->get_incoming_webhook_channel(),
        )
    );

    $response = wp_remote_post( $url, array('headers' => $headers, 'body' => $data));

    return ( array_key_exists( 'body', $response) && $response['body'] == 'ok' );

}