<?php 

defined( 'ABSPATH' ) || exit;

function woffice_user_approval_actions_menu() {
	$new_requests_count = woffice_user_registration_pending_requests_count();
    $menu_title = __('Woffice User Registration','woffice');
    if ($new_requests_count > 0) {
        $menu_title .= sprintf(' <span class="update-plugins count-%1$d"><span class="plugin-count">%1$d</span></span>', $new_requests_count);
    }

    $register_role = woffice_validate_bool_option(woffice_get_theming_option('register_role'));

    if($register_role){
        add_users_page(
            $menu_title,
            __('Woffice User Registration','woffice'),
            'manage_options',
            'woffice-user-actions',
            'woffice_user_actions_page'
        );
    }
}

function woffice_user_registration_pending_requests_count() {
    $args = [
        'role'    => 'subscriber',
        'meta_key' => 'status',
        'meta_value' => 'pending',
    ];

    $users = get_users($args);
    return count($users);
}

function woffice_user_actions_page() {
    $woffice_user_action_table = new Woffice_User_Registration_Actions_Table();
    $woffice_user_action_table->prepare_items();
    
    ?>
    <div class="wrap">
        <h2><?php _e('Woffice User Registration','woffice');?></h2>
        <form method="post">
            <?php wp_nonce_field( 'woffice-user-actions','woffice-user-actions'); ?>
            <?php
            	$woffice_user_action_table->display();
            ?>
        </form>
    </div>
    <?php
}

function woffice_handle_user_approval_actions() {
    $is_user_action = isset($_GET['page']) ? sanitize_text_field($_GET['page']) : false;

    if (isset($_GET['action']) && isset($_GET['user_id']) && 'woffice-user-actions' === $is_user_action) {
        $action = $_GET['action'];
        $user_id = (int) $_GET['user_id'];

        if(!wp_verify_nonce('woffice-user-actions', $_POST['woffice-user-actions'])){
            wp_die('You do not have sufficient permissions to perform this action.','woffice');
        }

        if (!current_user_can('edit_user', $user_id)) {
            wp_die('You do not have sufficient permissions to perform this action.','woffice');
        }

        switch ($action) {
            case 'approve':
                update_user_meta($user_id, 'woffice_user_role_status', 'approved');
                break;
            case 'reject':
                update_user_meta($user_id, 'woffice_user_role_status', 'rejected');
                break;
            case 'delete':
                delete_user_meta($user_id, 'woffice_user_role','');
                delete_user_meta($user_id, 'woffice_user_role_status','');
                break;
        }

        wp_redirect(remove_query_arg(['action', 'user_id']));
        exit;
    }
}

add_action('admin_menu', 'woffice_user_approval_actions_menu');
add_action('admin_init', 'woffice_handle_user_approval_actions');

function woffice_set_user_role_on_login($user_login, $user) {
    
    $user_status = get_user_meta($user->ID, 'woffice_user_role_status', true);
    $user_role = get_user_meta($user->ID, 'woffice_user_role', true);

    if ($user_status === 'approved') {
        $user->add_role($user_role);
    }
}
add_action('wp_login', 'woffice_set_user_role_on_login', 10, 2);

//remove selected role if user loggedout.
function woffice_remove_user_role_on_logout() {
    $user = wp_get_current_user();
    $user_status = get_user_meta($user->ID, 'woffice_user_role_status', true);
    $user_role = get_user_meta($user->ID, 'woffice_user_role', true);
    if ($user_role && $user_status === 'approved' || $user_status === 'deleted' || $user_status === 'rejected') {
        $user->remove_role($user_role);
    }
    
}
add_action('wp_logout', 'woffice_remove_user_role_on_logout');

