<?php
/**
 * Woffice Chat options
 * For full documentation, please visit: http://devs.redux.io/
 *
 * @package Redux Framework
 */
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Redux' ) ) {
	return;
}

 $alka_pro_chat_enabled = woffice_get_settings_option('alka_pro_chat_enabled');
 $alka_pro_chat_refresh_time = woffice_get_settings_option('alka_pro_chat_refresh_time');
 $alka_pro_chat_emojis_enabled = woffice_get_settings_option('alka_pro_chat_emojis_enabled');
 $alka_pro_chat_welcome_enabled = woffice_get_settings_option('alka_pro_chat_welcome_enabled');
 $alka_pro_chat_welcome_title = woffice_get_settings_option('alka_pro_chat_welcome_title');
 $alka_pro_chat_welcome_message = woffice_get_settings_option('alka_pro_chat_welcome_message');

Redux::set_section(
	$opt_name,
	array(
		'title'      => esc_html__( 'Chat', 'woffice' ),
		'id'         => 'chat-options-chat_select',
		'desc'       => esc_html__( 'For full documentation on this, visit: ', 'woffice' ) . '<a href="https://docs.woffice.io/" target="_blank">'.esc_html__('Woffice documentation','woffice').'</a>',
		'subsection' => true,
		'fields'     => array(
            array(
				'id'       => 'alka_pro_chat_enabled',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable the live chat.', 'woffice' ),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => $alka_pro_chat_enabled
			),
            array(
				'id'            => 'alka_pro_chat_refresh_time',
				'type'          => 'slider',
				'title'         => esc_html__( 'Refresh time', 'woffice' ),
				'desc'          => esc_html__( 'Live refresh time in milliseconds to fetch new messages once the chat is open, server performance are heavily affected by this.', 'woffice' ),
				'default'       => $alka_pro_chat_refresh_time,
				'min'           => 3000,
				'step'          => 1000,
				'max'           => 60000,
				'display_value' => 'label',
			),
            array(
				'id'       => 'alka_pro_chat_emojis_enabled',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable the emojis picker.', 'woffice' ),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => $alka_pro_chat_emojis_enabled
			),
            array(
				'id'       => 'alka_pro_chat_welcome_enabled',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable Welcome modal', 'woffice' ),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => $alka_pro_chat_welcome_enabled,
                'hint'     => array(
					'content' => __('This modal will be displayed only one time for each user, it can provide detail or rules for the chat.','woffice'),
				),
			),
            array(
				'id'       => 'alka_pro_chat_welcome_title',
				'type'     => 'text',
				'title'    => esc_html__( 'Welcome Title', 'woffice' ),
				'default'  => $alka_pro_chat_welcome_title,
      		),
              array(
				'id'       => 'alka_pro_chat_welcome_message',
				'type'     => 'textarea',
				'title'    => esc_html__( 'Welcome Message', 'woffice' ),
				'default'  => $alka_pro_chat_welcome_message,
      		),
        ),
	),
);