<?php
/**
 * Redux Framework Custom code options
 * For full documentation, please visit: http://devs.redux.io/
 *
 * @package Redux Framework
 */

 defined( 'ABSPATH' ) || exit;

 if ( ! class_exists( 'Redux' ) ) {
	 return;
 }
$plugins_url = plugins_url();

$custom_css = woffice_get_settings_option('custom_css');
$custom_js = woffice_get_settings_option('custom_js');
$footer_scripts = woffice_get_settings_option('footer_scripts');

Redux::set_section(
	$opt_name,
	array(
		'title'      => esc_html__( 'Custom Code', 'woffice' ),
		'id'         => 'select-custom_code',
		'desc'       => esc_html__( 'For full documentation on this, visit: ', 'woffice' ) . '<a href="https://docs.woffice.io/" target="_blank">'.esc_html__('Woffice documentation','woffice').'</a>',
		'subsection' => true,
		'fields'     => array(
			array(
				'id'       => 'custom_css',
				'type'     => 'ace_editor',
				'title'    => esc_html__( 'Custom css','woffice'),
				'subtitle' => esc_html__( 'Type your custom css here.','woffice' ),
				'mode'     => 'css',
				'theme'    => 'monokai',
				'desc'     => __('No need to set the tags <b>(<style></style>).</b> It is better to change the CSS changes here than editing the theme files ;) or you can create a child theme if you have a lot of changes.','woffice'),
				'default'  => $custom_css,
			),
            array(
				'id'       => 'section-customjs-start',
				'type'     => 'section',
                'title'    => esc_html__( 'Custom Javascript', 'woffice' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'       => 'custom_js',
				'type'     => 'ace_editor',
				'title'    => esc_html__( 'Custom JS','woffice'),
				'subtitle' => esc_html__( 'Type Your custom JQUERY/JAVASCRIPT here.','woffice'),
				'mode'     => 'javascript',
				'theme'      => 'monokai',
				'desc'     => __('No need to set the tags <b>(<script></script>).</b> It will understands the <strong>"$"</strong>, all is wrapped in a Jquery function.','woffice'),
				'default'  => $custom_js,
			),
            array(
				'id'       => 'footer_scripts',
				'type'     => 'ace_editor',
				'title'    => esc_html__( 'Footer Script','woffice'),
				'subtitle' => esc_html__( 'Type your custom scripts here.','woffice'),
				'mode'     => 'javascript',
				'theme'    => 'monokai',
				'desc'     => __('This section is perfect for <b>Google Analytics or other scripts like that,</b> it will be loaded in the footer. You have to wrap your code with <b>&lt;script&gt;&lt;/script&gt;</b>.','woffice'),
				'default'  => $footer_scripts,
			),
            array(
				'id'       => 'section-customjs-end',
				'type'     => 'section',
                'indent'   => false,
			),
		),
	)
);
