<?php
/**
 * Redux Framework Custom code options
 * For full documentation, please visit: http://devs.redux.io/
 *
 * @package Redux Framework
 */

 defined( 'ABSPATH' ) || exit;

 if ( ! class_exists( 'Redux' ) ) {
	 return;
 }
$plugins_url = plugins_url();

$dashboard_columns = woffice_get_settings_option('dashboard_columns');
$dashboard_drag_drop = woffice_unyson_switch_to_bool(woffice_get_settings_option('dashboard_drag_drop'));
$dashboard_headline_uppercase = woffice_unyson_switch_to_bool(woffice_get_settings_option('dashboard_headline_uppercase'));

Redux::set_section(
	$opt_name,
	array(
		'title'      => esc_html__( 'Main Options', 'woffice' ),
		'id'         => 'home-dashboard-main_options',
		'desc'       => esc_html__( 'For full documentation on this, visit: ', 'woffice' ) . '<a href="https://docs.woffice.io/" target="_blank">'.esc_html__('Woffice documentation','woffice').'</a>',
		'subsection' => true,

		'fields'     => array(
			array(
		        'id'       => 'dashboard_columns',
		        'type'     => 'select',
		        'title'    => esc_html__('Number of columns in the dashboard', 'woffice'),
		        'desc'     => esc_html__('This is only for non-mobiles devices, because it is responsive.', 'woffice'),
		        'options'  => array(
		            '1' =>  esc_html__( '1 Columns', 'woffice' ),
		            '2' =>  esc_html__( '2 Columns', 'woffice' ),
					'3' =>  esc_html__( '3 Columns', 'woffice' )
		        ), 
		        'default'  => $dashboard_columns,
		    ),
			array(
				'id'       => 'dashboard_drag_drop',
				'type'     => 'switch',
				'title'    => esc_html__( 'Allow Drag & Drop ?', 'woffice' ),
				'desc'     => esc_html__( 'User will be able to re-order their dashboard widgets.', 'woffice' ),
				'default'  => $dashboard_drag_drop,
			),
			array(
				'id'       => 'dashboard_headline_uppercase',
				'type'     => 'switch',
				'title'    => esc_html__( 'Uppercase Headlines ?', 'woffice' ),
				'desc'     => esc_html__( 'This is an option for the titles of the widgets in the dashboard page.', 'woffice' ),
				'default'  => $dashboard_headline_uppercase,
			),
		),
	)
);
