<?php 

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Redux' ) || !class_exists('Woffice_Google_Signing') ) {
	return;
}

$google_details = woffice_get_settings_option('google_details');


$google_enabled = woffice_unyson_switch_to_bool(woffice_get_settings_option('google_enabled'));
$google_enabled_default = ($google_enabled) ? $google_enabled : false;

$google_app_id = woffice_get_settings_option('google_app_id');

$google_app_secret = woffice_get_settings_option('google_app_secret');

$google_callback = class_exists('Woffice_Google_Signing') ? Woffice_Google_Signing::getCallbackUrl() : "";


Redux::set_section(
	$opt_name,
	array(
		'title'      => esc_html__( 'Google Options', 'woffice' ),
		'id'         => 'login-register-google_options',
		'desc'       => esc_html__( 'For full documentation on this, visit: ', 'woffice' ) . '<a href="https://docs.woffice.io/" target="_blank">'.esc_html__('Woffice documentation','woffice').'</a>',
		'subsection' => true,

		'fields'     => array(
			 array( 
		        'id'       => 'google_details',
		        'type'     => 'raw',
		        'full_width' => 'true',
		        'title'    => esc_html__('Setup', 'woffice'),
		        'desc'     => esc_html__('You will need to create a new project on Google from this page, as well as a new "OAuth 2.0 client IDs" from your credentials page:', 'woffice').' <a href="https://console.developers.google.com" target="_blank">console.developers.google.com</a>',
		        'content'  => $google_details
		    ),
			 array(
		        'id'       => 'google_enabled',
		        'type'     => 'switch',
		        'title'    => esc_html__('Enable', 'woffice'),
		        'desc'     => esc_html__('You will also need to have the above options set up. This is just so you can deactivate it without loosing your settings.','woffice'),
		        'default'  => $google_enabled_default,
		    ),
			 array( 
		        'id'       => 'google_callback_url',
		        'type'     => 'raw',
		        'full_width' => 'true',
		        'title'    => esc_html__('Your callback URL', 'woffice'),
		        'content'  => '<span class="highlight">'. $google_callback .'</span>'
		    ),
			array(
		        'id'=>'google_app_id',
		        'type' => 'textarea',
		        'title' => __('Client ID', 'woffice'),
		        'desc' => __('Your Google Project Client ID goes here.', 'woffice'),
		        'default' => $google_app_id,
		    ),
		    array(
		        'id'=>'google_app_secret',
		        'type' => 'textarea',
		        'title' => __('Client Secret', 'woffice'),
		        'desc' => __('Your Google Project Client Secret goes here.', 'woffice'),
		        'default' => $google_app_secret,
		    ),
		),
	)
);
