<?php
/* Roles array ready for options */
global $wp_roles;
    $tt_roles_tmp = array();
foreach ($wp_roles->roles as $key=>$value){
    $tt_roles_tmp[$key] = $value['name'];
}

// Old wiki options from unyson
$enable_wiki_like = woffice_unyson_switch_to_bool(woffice_get_settings_option('enable_wiki_like'));
$enable_wiki_accordion = woffice_unyson_switch_to_bool(woffice_get_settings_option('enable_wiki_accordion'));
$wiki_sortbylike = woffice_unyson_switch_to_bool(woffice_get_settings_option('wiki_sortbylike'));

// Old projects options from unyson
$projects_filter = woffice_get_settings_option('projects_filter');
$projects_date_filter = woffice_get_settings_option('projects_date_filter');
$projects_status_filter = woffice_get_settings_option('projects_status_filter');
$hide_projects_completed = woffice_get_settings_option('hide_projects_completed');
$projects_groups = woffice_unyson_switch_to_bool(woffice_get_settings_option('projects_groups'));
$projects_assigned_email = woffice_unyson_switch_to_bool(woffice_get_settings_option('projects_assigned_email'));
$projects_assigned_email_content = woffice_get_settings_option('projects_assigned_email_content');
$project_daily_notification = woffice_unyson_switch_to_bool(woffice_get_settings_option('project_daily_notification'));
$projects_assigned_dailyemail_notification = woffice_get_settings_option('projects_assigned_dailyemail_notification');
$projects_task_review_subject = woffice_get_settings_option('projects_task_review_subject');
$projects_task_review_content = woffice_get_settings_option('projects_task_review_content');
$page_comments = woffice_unyson_switch_to_bool(woffice_get_settings_option('page_comments'));
$hide_learndash_meta = woffice_unyson_switch_to_bool(woffice_get_settings_option('hide_learndash_meta'));
$like_engine = woffice_get_settings_option('like_engine');

/* End */

Redux::set_section(
	$opt_name,
	array(
		'title'      => esc_html__( 'Posts/Wiki/Projects', 'woffice' ),
		'id'         => 'options-post_project_wiki',
		'desc'       => esc_html__( 'For full documentation on this, visit: ', 'woffice' ) . '<a href="https://docs.woffice.io/" target="_blank">'.esc_html__('Woffice documentation','woffice').'</a>',
		'subsection' => true,
		'fields'     => array(
			array(
                'id'        => 'ppw-accordion-begin-1',
                'type'      => 'accordion',
                'title'     => 'Wiki options',
                'position'  => 'start',    
            ),
			array(
				'id'       => 'enable_wiki_like',
				'type'     => 'switch',
				'title'    => esc_html__( 'Display like button', 'woffice' ),
				'desc'     => esc_html__( 'Do you want display wiki button and counter for wiki elements?', 'woffice' ),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => $enable_wiki_like,
			),   
			array(
				'id'       => 'enable_wiki_accordion',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable collapsing of sub categories', 'woffice' ),
				'desc'     => esc_html__( 'Do you want enable an accordion for subcategories of wiki? (they will be closed by default)', 'woffice' ),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => $enable_wiki_accordion,
			),   
			array(
				'id'       => 'wiki_sortbylike',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable Sorting of wiki by likes', 'woffice' ),
				'desc'     => esc_html__( 'Do you want add a button to wiki list that allow to sort the result by likes?', 'woffice' ),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => $wiki_sortbylike,
			),   
			array(
				'id'       => 'wiki_excluded_categories',
				'type'     => 'select',
				'data'     => 'terms',
				'args'     => array(
								'taxonomies' => array( 'wiki-category' ),
								'hide_empty' => false,
							),
				'multi'    => true,
				'title'    => esc_html__( 'Wiki Exclude categories', 'woffice' ),
				'desc'     => esc_html__( 'Do you want to exclude categories from the Wiki page ?', 'woffice' ),
			),
			array(
                'id'        => 'ppw-accordion-end-1',
                'type'      => 'accordion',
                'position'  => 'end'
            ),
			array(
                'id'        => 'ppw-accordion-begin-2',
                'type'      => 'accordion',
                'title'     => 'Projects options',
                'position'  => 'start',    
            ),
			array(
				'id'       => 'projects_filter',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable category filter', 'woffice' ),
				'desc'     => esc_html__( 'This is a dropdown button to filter projects by category', 'woffice' ),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => $projects_filter,
			),
			array(
				'id'       => 'projects_date_filter',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable date sorting', 'woffice' ),
				'desc'     => esc_html__( 'This is a dropdown button to sort the projects by publication date.', 'woffice' ),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => $projects_date_filter,
			),
			array(
				'id'       => 'projects_status_filter',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable the status filter', 'woffice' ),
				'desc'     => esc_html__( 'This is a toggle button to show/hide the projects based on its status.', 'woffice' ),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => $projects_status_filter,
			),
			array(
				'id'       => 'hide_projects_completed',
				'type'     => 'switch',
				'title'    => esc_html__( 'Hide archived projects by default', 'woffice' ),
				'desc'     => esc_html__( 'If the archived projects have to be displayed in the listing or not by default.', 'woffice' ),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => $hide_projects_completed,
			),
			array(
				'id'       => 'projects_groups',
				'type'     => 'switch',
				'title'    => esc_html__( 'Include in Buddypress Groups ?', 'woffice' ),
				'desc'     => esc_html__( 'A new project category will be created for each Buddypress group and all members set as members of the project.', 'woffice' ),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => $projects_groups,
			),
			array(
				'id'       => 'projects_assigned_email',
				'type'     => 'switch',
				'title'    => esc_html__( 'Notice user on task assignment ?', 'woffice' ),
				'desc'     => esc_html__( 'A new project category will be created for each Buddypress group and all members set as members of the project.', 'woffice' ),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => $projects_assigned_email,
			),
			array(
				'id'       => 'projects_assigned_email_content',
				'type'     => 'textarea',
				'title'    => esc_html__( 'Email\'s content', 'woffice' ),
				'subtitle' => esc_html__( 'This is the content of the email before the task name. Dynamic variables that will be replaced automatically: {user_name}, {project_url}, {project_title}, {todo_title}', 'woffice' ),
				'default'  => $projects_assigned_email_content,
			),
			array(
				'id'       => 'project_daily_notification',
				'type'     => 'switch',
				'title'    => esc_html__( 'Projects Daily Notification', 'woffice' ),
				'desc'     => esc_html__( 'Projects Daily Notification Reminder.', 'woffice' ),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => $project_daily_notification,
			),
			array(
				'id'       => 'projects_assigned_dailyemail_notification',
				'type'     => 'textarea',
				'title'    => esc_html__( 'Daily Email Notification Content', 'woffice' ),
				'subtitle' => esc_html__( 'This is the content of the email before the task name. Dynamic variables that will be replaced automatically: {user_name}, {project_url}, {project_title}, {todo_title}', 'woffice' ),
				'default'  => $projects_assigned_dailyemail_notification,
			),
			array(
				'id'       => 'projects_task_review_subject',
				'type'     => 'text',
				'title'    => esc_html__( 'Task Review Notification Subject', 'woffice' ),
				'default'  => $projects_task_review_subject,
				'desc'     => esc_html__( 'This is the subject task request review.', 'woffice' ),
			),
			array(
				'id'       => 'projects_task_review_content',
				'type'     => 'textarea',
				'title'    => esc_html__( 'Task Review Notification Content', 'woffice' ),
				'subtitle' => esc_html__( 'This is the content of the email before the task name. Dynamic variables that will be replaced automatically: {user_name}, {project_url}, {todo_title}', 'woffice' ),
				'default'  => $projects_task_review_content,
			),
			array(
                'id'        => 'ppw-accordion-end-2',
                'type'      => 'accordion',
                'position'  => 'end'
            ),
			array(
                'id'        => 'ppw-accordion-begin-3',
                'type'      => 'accordion',
                'title'     => 'Blog/Pages options',
                'position'  => 'start',    
            ),
			array(
				'id'       => 'page_comments',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show comments on pages', 'woffice' ),
				'desc'     => esc_html__( 'Do you want to display the comments to allow user to comment on pages ? If it you choose "show" you will still be able to override it on every page.', 'woffice' ),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => $page_comments,
			),
			array(
                'id'        => 'ppw-accordion-end-3',
                'type'      => 'accordion',
                'position'  => 'end'
            ),
			array(
                'id'        => 'ppw-accordion-begin-4',
                'type'      => 'accordion',
                'title'     => 'LearnDash Options',
                'position'  => 'start',    
            ),
			array(
				'id'       => 'hide_learndash_meta',
				'type'     => 'switch',
				'title'    => esc_html__( 'Hide meta below LearnDash pages', 'woffice' ),
				'desc'     => esc_html__( 'Meta below LearnDash pages contains: author, date, category, comments', 'woffice' ),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => $hide_learndash_meta,
			),
			array(
                'id'        => 'ppw-accordion-end-4',
                'type'      => 'accordion',
                'position'  => 'end'
            ),
			array(
                'id'        => 'ppw-accordion-begin-5',
                'type'      => 'accordion',
                'title'     => 'Other Options',
                'position'  => 'start',    
            ),
			array(
                'id'       => 'like_engine',
                'type'     => 'select',
                'multi'    => false,
                'title'    => __('How likes are saved ?', 'woffice'), 
                'desc'     => __("If you choose to do it by users, you need Buddypress. It's for both the blog and the wiki.", 'woffice'),
                'options'  => array(
					'ips' => __('Ips', 'woffice'),
					'members' => __('Members IDs', 'woffice')
           	),
                'default'  => $like_engine ? $like_engine : 'ips'
            ),
			array(
                'id'        => 'ppw-accordion-end-5',
                'type'      => 'accordion',
                'position'  => 'end'
            ),
		),
	),
);