<?php 

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Redux' ) ) {
	return;
}

// We fetch all the Buddypress xprofile_fields :
$tt_xprofile_tmp = array();
if (woffice_bp_is_active( 'xprofile' ) && function_exists('woffice_get_xprofile_table')) {
    global $wpdb;
    $table_name = woffice_get_xprofile_table('fields');

    $sqlStr = "SELECT id, name, parent_id, type type FROM ".$table_name;
    $fields = $wpdb->get_results($sqlStr);

    if(count($fields) > 0) {
        $sliced_fields = array_slice($fields,1);
        foreach ($sliced_fields as $value) {
            $tt_xprofile_tmp[$value->id] = $value->name;
        }
    }
}

global $wp_roles;
$tt_roles = array();
foreach ($wp_roles->roles as $key=>$value){
    $tt_roles[$key] = $value['name'];
}
$tt_roles_tmp = $tt_roles;
$tt_roles_tmp_without_admins = $tt_roles;
unset($tt_roles_tmp_without_admins['administrator']);
unset($tt_roles_tmp_without_admins['super_admin']);

$roles_excluded_in_the_form_array = array();
$roles_excluded_in_the_form = woffice_get_settings_option('roles_excluded_in_the_form');
$roles_excluded_in_the_form_default = ($roles_excluded_in_the_form) ? $roles_excluded_in_the_form : $roles_excluded_in_the_form_array;

$register_buddypress_specific = woffice_get_settings_option('register_buddypress_specific');

$register_buddypress_specific_default = array();
if(isset($register_buddypress_specific) && !empty($register_buddypress_specific)){
	$register_buddypress_specific_default = $register_buddypress_specific;
}


$register_message = woffice_get_settings_option('register_message');
$register_message_default = ($register_message) ? $register_message : 'If you don\'t have any account yet, you can register now.';

$email_verification = woffice_unyson_switch_to_bool(woffice_get_settings_option('email_verification'));
$email_verification_default = ($email_verification) ? $email_verification : true;

$register_autoredirect = woffice_unyson_switch_to_bool(woffice_get_settings_option('register_autoredirect'));
$register_autoredirect_default = ($register_autoredirect) ? $register_autoredirect : false;

$register_new_user_email = woffice_unyson_switch_to_bool(woffice_get_settings_option('register_new_user_email'));
$register_new_user_email_default = ($register_new_user_email) ? $register_new_user_email : false;

$register_new_user_email_to_admin = woffice_unyson_switch_to_bool(woffice_get_settings_option('register_new_user_email_to_admin'));
$register_new_user_email_to_admin_default = ($register_new_user_email_to_admin) ? $register_new_user_email_to_admin : false;

$register_buddypress = woffice_unyson_switch_to_bool(woffice_get_settings_option('register_buddypress'));
$register_buddypress_default = ($register_buddypress) ? $register_buddypress : false;

$register_role = woffice_unyson_switch_to_bool(woffice_get_settings_option('register_role'));
$register_role_default = (isset($register_role)) ? $register_role : false;

$register_password_confirmation = woffice_unyson_switch_to_bool(woffice_get_settings_option('register_password_confirmation'));
$register_password_confirmation_default = (isset($register_password_confirmation)) ? $register_password_confirmation : false;

$register_last_name = woffice_unyson_switch_to_bool(woffice_get_settings_option('register_last_name'));
$register_last_name_default = (isset($register_last_name)) ? $register_last_name : false;

$register_strong_password = woffice_unyson_switch_to_bool(woffice_get_settings_option('register_strong_password'));
$register_strong_password_default = (isset($register_strong_password)) ? $register_strong_password : false;

$register_captcha = woffice_unyson_switch_to_bool(woffice_get_settings_option('register_captcha'));
$register_captcha_default = (isset($register_captcha)) ? $register_captcha : false;

$register_captcha_question = woffice_get_settings_option('register_captcha_question');
$register_captcha_question_default = (isset($register_captcha_question)) ? $register_captcha_question : '4+4';

$register_captcha_answer = woffice_get_settings_option('register_captcha_answer');
$register_captcha_answer_default = (isset($register_captcha_answer)) ? $register_captcha_answer : '8';

$register_pmp = woffice_unyson_switch_to_bool(woffice_get_settings_option('register_pmp'));
$register_pmp_default = (isset($register_pmp)) ? $register_pmp : false;

$register_custom_domain_array_default = array();
$register_custom_domain_array = woffice_get_settings_option('register_custom_domain_array');
if(isset($register_custom_domain_array) && !empty($register_custom_domain_array)){
	$register_custom_domain_array_default = $register_custom_domain_array;
}


Redux::set_section(
	$opt_name,
	array(
		'title'      => esc_html__( 'Registers Options', 'woffice' ),
		'id'         => 'login-register-register_options',
		'desc'       => esc_html__( 'For full documentation on this, visit: ', 'woffice' ) . '<a href="https://docs.woffice.io/" target="_blank">'.esc_html__('Woffice documentation','woffice').'</a>',
		'subsection' => true,

		'fields'     => array(
			array(
		        'id'    => 'register_message',   
		        'type'  => 'text',
		        'value' => $register_message_default,
		        'title' => __( 'Register message', 'woffice' ),
		        'desc'  => __('This is the text displayed before the Register button if the anyone can register in the Wordpress settings.','woffice'),
		    ), 
			array(
		        'id'       => 'email_verification',
		        'type'     => 'switch',
		        'title'    => esc_html__('Email verification', 'woffice'),
		        'desc'     => esc_html__('Send am email to the user to validate him email address.', 'woffice'),
		        'hint'  =>	array(
						    'content' => __('you have to set the page in BuddyPress > Settings > Pages.', 'woffice'),
						    ),
		        'default'  => $email_verification_default,
		    ),
		    array(
		        'id'       => 'register_new_user_email',
		        'type'     => 'switch',
		        'title'    => esc_html__('Send Email to user on registration?', 'woffice'),
		        'desc'     => esc_html__('When an user complete the registration, send an email to the user with a confirmation about the registration process.', 'woffice'),
		        'default'  => $register_new_user_email_default,
		    ),
		    array(
		        'id'       => 'register_new_user_email_to_admin',
		        'type'     => 'switch',
		        'title'    => esc_html__('Send Email to admin on registration?', 'woffice'),
		        'desc'     => esc_html__('When an user complete the registration, send an email to the admin to alert him about the new registration.', 'woffice'),
		        'default'  => $register_new_user_email_to_admin_default,
		    ),
		    array(
		        'id'       => 'register_buddypress',
		        'type'     => 'switch',
		        'title'    => esc_html__('Buddypress Xprofile fields?', 'woffice'),
		        'desc'     => esc_html__('Do you want to see the Buddypress Xprofile fields from the "Base" displayed on the register form ? Thus, you can add as many field as you like.', 'woffice'),
		        'default'  => $register_buddypress_default,
		    ),
		    array(
				'id'       => 'register_buddypress_specific',
				'type'     => 'select',
				'multi'     => true,
				'title'    => esc_html__( 'Specific xprofile Fields?', 'woffice' ),
				'desc'     => esc_html__( 'If you want to display only specific xprofile fields on the registration form. By default - if you set the setting above to "yep", all fields will be displayed.', 'woffice' ),
                'default' => $register_buddypress_specific_default,
                'options' => $tt_xprofile_tmp
			),          
		    array(
		        'id'       => 'register_role',
		        'type'     => 'switch',
		        'title'    => esc_html__('Role field in the form', 'woffice'),
		        'desc'     => esc_html__('Do you want to see the Role field in the registration form ? Of course, "administrator" is not in the option.', 'woffice'),
		        'default'  => $register_role_default,
		    ),
		    array(
		        'id'       => 'register_password_confirmation',
		        'type'     => 'switch',
		        'title'    => esc_html__('Password confirmation field in the form?', 'woffice'),
		        'desc'     => esc_html__('Do you want to see the password confirmation field in the registration form?', 'woffice'),
		        'default'  => $register_password_confirmation_default,
		    ),
		    array(
		        'id'       => 'register_last_name',
		        'type'     => 'switch',
		        'title'    => esc_html__('Last name field in the form?', 'woffice'),
		        'desc'     => esc_html__('Do you want to see the last name field in the registration form?', 'woffice'),
		        'default'  => $register_last_name_default,
		    ),
		     array(
				'id'       => 'roles_excluded_in_the_form',
				'type'     => 'select',
				'multi'     => true,
				'title'    => esc_html__( 'Exclude roles from the form', 'woffice' ),
				'desc'     => esc_html__( 'Do you want to exclude some roles from the register form? Admin and Super Admin are already excluded.', 'woffice' ),
                'options' => $tt_roles_tmp_without_admins,
                'default' => $roles_excluded_in_the_form_default
			),

		    array(
		        'id'       => 'register_strong_password',
		        'type'     => 'switch',
		        'title'    => esc_html__('Strong password?', 'woffice'),
		        'desc'     => esc_html__('Do you want to enforce your new users to use a strong password (at least 6 characters, 1 uppercase, 1 lowercase, 1 number and 1 specific character)?', 'woffice'),
		        'default'  => $register_strong_password_default,
		    ),
		    array(
		        'id'       => 'register_captcha',
		        'type'     => 'switch',
		        'title'    => esc_html__('Captcha on Register form ?', 'woffice'),
		        'desc'     => esc_html__('Do you want to see a captcha on the register page, if you select "yep" please fill the fields below.', 'woffice'),
		        'default'  => $register_captcha_default,
		    ),
		    array(
		        'id'    => 'register_captcha_question',   
		        'type'  => 'text',
		        'value' => $register_captcha_question_default,
		        'title' => __( 'register_captcha_question', 'woffice' ),
		        'desc' => __('A question that humans can reply but not robots.','woffice'),
		    ),
		    array(
		        'id'    => 'register_captcha_answer',   
		        'type'  => 'text',
		        'value' => $register_captcha_answer_default,
		        'title' => __( 'Captcha Answer', 'woffice' ),
		        'desc'  => __('The answer of the question above.','woffice'),
		    ),
		    array(
		        'id'       => 'register_pmp',
		        'type'     => 'switch',
		        'title'    => esc_html__('Paid Membership Pro', 'woffice'),
		        'desc'     => esc_html__('Do you want to redirect the user to your Levels page when the user clicks on the "Register" button. This page needs to be public and excluded from the redirection process.', 'woffice'),
		        'default'  => $register_pmp_default,
		    ),
	        array(
			    'id'=>'register_custom_domain_array',
			    'type' => 'multi_text',
			    'title' => __('Allow only a certain Email domain to register.', 'woffice'),
			    'desc' => __('We will check if that domain is in the email address in order to register to the site. Example : gmail.com','woffice'),
			    'default' => $register_custom_domain_array_default,
		    ),
		),
	)
);
