<?php

defined( 'ABSPATH' ) || exit;
$plugins_url = plugins_url();

$old_options = get_option('fw_theme_settings_options:woffice');
$migrated_option = woffice_get_theming_option('kanban_columns');

$default = array(
    array(
        'title' => __('TODO','woffice-kanban'),
        'status_slug' => 'todo',
        'color' => '#0275d8',
    ),
    array(
        'title' => __('Active','woffice-kanban'),
        'status_slug' => 'working',
        'color' => '#5bc0de',
    ),
    array(
        'title' => __('Urgent','woffice-kanban'),
        'status_slug' => 'urgent',
        'color' => '#f0ad4e',
    ),
    array(
        'title' => __('Completed','woffice-kanban'),
        'status_slug' => 'completed',
        'color' => '#5cb85c',
    ),
);

if(empty($old_options['kanban-columns'])){
    $old_options['kanban-columns'] = $default;
}

$migrated_option = woffice_get_theming_option('kanban_columns');
if(isset($old_options['kanban-columns']) && !empty($old_options['kanban-columns'])){
    $new_field = array();
    if(isset($migrated_option['title']) && empty($old_options['title'])){
        foreach($old_options['kanban-columns'] as $key => $column){
            $new_field['redux_repeater_data'][]['title'] = '';
            $new_field['title'][] = $column['title'];
            $new_field['color'][] = $column['color'];
        }
        if (isset($migrated_option['title']) && !$migrated_option['title']) {
            Redux::set_option($opt_name, 'kanban_columns', $new_field);
        }
    }
}


Redux::set_section(
	$opt_name,
	array(
		'title'      => esc_html__( 'Woffice Kanban', 'woffice' ),
		'id'         => 'option-woffice_kanban_options',
		'desc'       => esc_html__( 'For full documentation on this, visit: ', 'woffice' ) . '<a href="https://docs.woffice.io/" target="_blank">'.esc_html__('Woffice documentation','woffice').'</a>',
		'subsection' => true,
		'fields'     => array(
            array(
                'id'          => 'kanban_columns',
                'type'        => 'repeater',
                'title'       => esc_html__( 'Column Settings', 'woffice' ),
                'full_width'  => false,
                'subtitle'    => '',
                'item_name'   => '',
                'group_values' => true, 
                'sortable'    => true,
                'active'      => false,
                'collapsible' => false,
                'limit'       => 6,
                'fields'      => array(
                    array(
                        'id'       => 'title',
                        'type'     => 'text',
                        'title'    => esc_html__( 'Column Title', 'woffice' ),
                        'desc'  => esc_html__('This is your background color (used in the column title background color).', 'woffice'),
                        'validate' => array( 'numeric', 'not_empty' ),
                    ),
                    array(
                        'id'       => 'color',
                        'type'     => 'color',
                        'title'    => esc_html__( 'Column Background color', 'woffice' ),
                        'default'  => 'rgba(49,70,197,0.52)',
                        'transparent' => false,
                        'color_alpha' => true
                    ),
                ),
            ),
            array(
				'id'       => 'kanban_status_notification_subject',
				'type'     => 'text',
				'title'    => esc_html__( 'Kanban Status Changed Notification Subject', 'woffice' ),
                'desc'     => esc_html__( 'This is the subject when status is changed.', 'woffice' ),
				'default'  => isset($old_options['kanban_status_notification_subject']) ? $old_options['kanban_status_notification_subject'] : 'Your task status is changed',
			),
            array(
				'id'      => 'kanban_status_notification_content',
				'type'    => 'editor',
				'title'   => esc_html__('Kanban Status change Notification Content', 'woffice' ),
                'desc'     => esc_html__('This is the content of the email before the task name. Dynamic variables that will be replaced automatically: {user_name}, {project_url}, {todo_title}', 'woffice' ),
                'default' => isset($old_options['kanban_status_notification_content']) ? $old_options['kanban_status_notification_content'] : 'Hey {user_name}, <br> Your task status is changed from <b>{old_status}</b> to <b>{new_status}</b> in task {task_title} in project {project_url}.',
				'args'    => array(
					'wpautop'       => false,
					'media_buttons' => false,
					'textarea_rows' => 5,
					'teeny'         => false,
					'quicktags'     => false,
				),
			),            
		),
	)
);