<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://woffice.io
 * @since      1.0.0
 *
 * @package    Woffice_Credit_System
 * @subpackage Woffice_Credit_System/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Woffice_Credit_System
 * @subpackage Woffice_Credit_System/public
 * @author     Woffice  <https://woffice.io>
 */
class Woffice_Credit_System_Public {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of the plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/woffice-credit-system-public.min.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Woffice_Credit_System_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Woffice_Credit_System_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/woffice-credit-system-public.min.js', array( 'jquery' ), $this->version, false );

		$args = array(
			'ajax_url' => admin_url( 'admin-ajax.php' ),
			'project_id' => get_the_ID(),
			'button_content' => sprintf('<a class="woffice-ai-action" data-type="title" href="javascript:void(0)"><span class="woffice-icon woffice-icon-ai"></span> %1$s</a>',__('Generate title using AI','woffice-credits')),
			'regenerate_content_text' => __('Regenerate Content','woffice-credits'),
			'regenerate_title_text' => __('Regenerate Title','woffice-credits')
		);

		wp_localize_script($this->plugin_name,'WOCS_AI',$args);

		wp_enqueue_script( $this->plugin_name.'_jquery.hoverpulse', plugin_dir_url( __FILE__ ) . 'js/jquery.hoverpulse.js', array( 'jquery' ), $this->version, false );

	}

}
