/**
 * Main Woffice object
 *
 * @since 2.5.0
 * @type {{}}
 */
var Woffice_Credit_System = {

    /**
	 * Initialize the Woffice's JS
	 *
	 * @param {jQuery} $
     */
    init: function ($) {

		"use strict";

		var self = this;

		self.$ = (typeof $ === 'undefined') ? jQuery : $;

		/*
		 * When the page is starting
         */
        self.$(window).load(function() {
			self.Events.watch();
			self.Handler.watch();
            self.Todos_Actions.watch();
		});

		/*
         * Watchers, binding events after page load
         */

		{
			self.Events.watch();
			self.Handler.watch();
		}

	},

	Events: {

		watch: function() {
			var self = this;
			var $ = Woffice_Credit_System.$;
			var body = $('body');
			body.find('#post_title').after(WOCS_AI.button_content);

            $('.calendar-event-new-btn').on('click',function(){
                body.find('#woffice-event-form .form-row:first-child .form-group').append(WOCS_AI.button_content);
            });
		}
	},

	Handler: {

		watch: function() {
            var self = this;
			var $ = Woffice_Credit_System.$;          
            var body = $('body');
            var title_selector;
            body.on('click','.woffice-ai-action, .woffice-ai-regeneration',function() {
                title_selector = $(this).siblings('input[type="text"]');
                title = title_selector.val();
                title_selector.addClass('wocs_ai_accessor');
                var rq_type = $(this).data('type');
                var  title_val = '';
                
                if(rq_type == 'project_content' || rq_type == 'blog_content' || rq_type == 'blog_image'){
                    title_val = $('#post_title').val();
                    if(title_val == ''){
                        alert('Title must be required for AI');
                        return;
                    }
                }
                
                $(body).find('#aimodal .woffice-ai-regeneration').text('Regenrate ' + rq_type.replace("_", " "));
                if(title == ''){
                    alert('Title must be required for AI');
                    return;
                }
                if(title == undefined) {
                    title = $('.woffice-ai-action').siblings('input[type="text"]').val();
                }
                $('.woffice-ai-regeneration').attr('data-type',rq_type);
                $.ajax({
                    type: "POST",
                    url: Woffice.data.ajax_url.toString(),
                    data: {
                        action: 'woffice_ai_request',
                        title:title,
                        nonce: WOFFICE.nonce,
                        rq_type: rq_type
                    },
                    beforeSend: function() {
                        
                        $('#aimodal .ai-spinner').show();
                        $('#aimodal').modal('show');
                        rq_type = rq_type.replace("_", " ");
                        $('.modal-footer a.woffice-ai-regeneration').text('Regenrate ' + rq_type);
                        $('#aimodal .ai-listoutput, #aimodal .modal-title-resultfor, #aimodal .ai-avail-credit').html(" ");
                        $('#aimodal .ai-avail-credit-wrapper').hide();
                    },   
                    success: function (data) {
                        var result = JSON.parse(data);
                        $('#aimodal .ai-listoutput').html(" ");
                        $('#aimodal .ai-spinner').hide();
                        $('#aimodal .modal-title-resultfor').text(title);
                        $('#aimodal .ai-listoutput').html(result.output);
                        self.image_zoom();
                        $('#aimodal .ai-avail-credit').html(result.credit);
                        $('#aimodal .ai-avail-credit-wrapper').show()
                        self.toogle_content();
                    } 
                });
            });

            body.on('click','.wpcs_copier',function() {
               item_Val = $(this).parent('span').siblings('.wocs_ai_title').text(); 
               body.find('.wocs_ai_accessor').val(item_Val);
            });

            body.on('click','.wpcs_content_copier',function() { 
                item_Val = $(this).siblings('span').html();
                if ( $('#wp-post_content-wrap').hasClass('tmce-active') ){
                    tinymce.get("post_content").execCommand('mceInsertContent',true,item_Val);              
                } else{
                    tinymce.get("post_content").execCommand('mceInsertContent',true,item_Val);
                }
            });
            
            body.on('click','.wpcs_image_copier',function() {
                var selected_img_src = $(this).parent('span').siblings('.wocs_ai_image').attr('src');
                
                $('#woffice_ai_select_img').val(selected_img_src);
                $('#primary-post-form .woimg_preview').html('');
                $('#primary-post-form .woimg_preview').html('<img class="ai_selected_preview" width="100" height="100" src="'+selected_img_src+'">');
                $('#aimodal').modal('hide');
            });

		},
        toogle_content:function(){ 
            var $ = Woffice_Credit_System.$;
            $(".wocs_ai_content p:nth-of-type(1n+4)").hide();
                
                $(".btn-more").on('click',function() {
                    $(this).css('visibility', 'hidden');
                    $(this).siblings(".wocs_ai_content").find("p:gt(2)").toggle();
                });
        },
         image_zoom: function() {
            var $ = Woffice_Credit_System.$;
            var body = $('body');
            if(jQuery('.wocs_ai_image').length > 0) {
               jQuery('.wocs_ai_image').hoverpulse({
                    size: 200,
                    speed: 200
                });
            }             
        }     
	},


    Todos_Actions: {
        watch: function() {

            if(typeof WOFFICE_TODOS == "undefined") {
                return;
            }

			var $ = Woffice_Credit_System.$;
            var body = $('body');
            body.on('click','#selectll_ai_todos',function() {
                $(".wocs_ai_list input:checkbox").prop('checked', $(this).prop("checked"));
            });
            
            body.on('click','.ai_add_todos',function() {
                var todos_items = $('.ai_todos_form').serialize();
                $.ajax({
                    type: "POST",
                    url: Woffice.data.ajax_url.toString(),
                    data: {
                        action: 'woffice_ai_add_todos',
                        _wpnonce: WOFFICE_TODOS.nonce,
                        id:WOCS_AI.project_id,
                        type:'project',
                        todos: todos_items
                    },
                    beforeSend: function() {
                        
                    },   
                    success: function (data) {
                        var result = JSON.parse(data);
                        $('.ai-message-wrapper .alert').text(result.message);
                        if(result.status){
                            $('.ai-message-wrapper').addClass('d-block');
                            $('.ai-message-wrapper .alert').addClass('alert-success');
                        } else {
                            $('.ai-message-wrapper').addClass('d-block');
                            $('.ai-message-wrapper .alert').addClass('alert-danger');
                        }
                    } 
                });
                
            });
        }
    }


}


/**
 * Start it!
 *
 * We give it a jQuery object to play with
 */
 Woffice_Credit_System.init(jQuery);
