<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://woffice.io
 * @since             1.0.0
 * @package           Woffice_Credit_System
 *
 * @wordpress-plugin
 * Plugin Name:       Woffice Credits
 * Plugin URI:        woffice.io
 * Description:       Use Woffice Credit to generate AI-based text and many more to come.
 * Version:           1.0.0
 * Author:            Woffice 
 * Author URI:        https://woffice.io
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       woffice-credits
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-woffice-credit-system.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_woffice_credit_system() {

	$plugin = new Woffice_Credit_System();
	$plugin->run();

}
run_woffice_credit_system();
