<?php
defined( 'ABSPATH' ) || exit;
/*
 * These are plugin territory functions
 */

if (!function_exists('woffice_get_extension_uri')) {
	/**
	 * Get the Woffice URI extension of a Unyson extension
	 *
	 * @param string $extension (without the woffice- suffix
	 * @param string $path
	 *
	 * @return string
	 */
	function woffice_get_extension_uri($extension, $path = '')
	{
		return plugin_dir_url( __FILE__ ) .'extensions/woffice-'. $extension .'/'. $path;
	}
}

if(!function_exists('woffice_send_user_registration_email')) {
	/**
	 * Send an email to registered user that confirm the complete registration
	 *
	 * @param int $user_id Id of registered user
	 */
	function woffice_send_user_registration_email($user_id){

		$register_new_user_email = woffice_validate_bool_option(woffice_get_theming_option('register_new_user_email'));
		if($register_new_user_email || ! woffice_is_custom_login_page_enabled() )
			return;

		$site_name = get_option( 'blogname' );
		$admin_email = get_option( 'admin_email' );

		$user = get_userdata( $user_id );

		//Body
		$message = sprintf(esc_html__( 'Your registration on %s is completed.', 'woffice' ), $site_name) . "\r\n\r\n";
		$message .= esc_html__('Login url:', 'woffice'). ' ' . wp_login_url()."\r\n";
		$message .= esc_html__('Username:', 'woffice') . ' ' . $user->user_login ."\r\n";
		$message .= esc_html__('Password: The password chosen during the registration', 'woffice');

		/**
		 * Filter the body of the email sent to the user once he signs up
		 *
		 * @param string $message
		 * @param WP_User $user
		 */
		$message = apply_filters( 'woffice_user_registration_message_body', $message, $user );

		//Subject
		$subject = esc_html__( 'Your registration is completed', 'woffice' );
		/**
		 * Filter the subject of the email sent to the user once he signs up
		 *
		 * @param string $subject
		 * @param WP_User $user
		 */
		$subject = apply_filters( 'woffice_user_registration_message_subject', $subject, $user );

		//Headers
		$headers = array(
			"From: \"{$site_name}\" <{$admin_email}>\n",
			"Content-Type: text/plain; charset=\"" . get_option( 'blog_charset' ) . "\"\n",
		);
		/**
		 * Filter the headers of the email sent to the user once he signs up
		 *
		 * @param string $message
		 * @param WP_User $user
		 */
		$headers = apply_filters( 'woffice_user_registration_message_headers', $headers );

		wp_mail( $user->user_email, $subject, $message, $headers );
	}
}

if(!function_exists('woffice_bp_is_active')) {
	/**
	 * It's a wrapper for the function bp_is_active(). Checks if a given BuddyPress component is active
	 *
	 * @param $component
	 *
	 * @return bool
	 */
	function woffice_bp_is_active($component) {
		return (function_exists('bp_is_active') && bp_is_active( $component ));
	}
}

if (!function_exists('woffice_decode')) {
	/**
	 * It's a wrapper for the base64_decode() PHP
	 *
	 * @param string $content
	 *
	 * @return string
	 */
	function woffice_decode($content) {
		return base64_decode($content);
	}
}

if (!function_exists('woffice_get_settings_option')) {
	/**
	 * Get an option from the theme settings
	 *
	 * @param string $option
	 * @param string $default
	 *
	 * @return mixed|null|string
	 */
	function woffice_get_settings_option($option, $default = ''){
		$option_value = (function_exists( 'fw_get_db_settings_option' )) ? fw_get_db_settings_option($option) : $default;

		/**
		 * Overrides the value returned from the function woffice_get_settings_option($option)
		 *
		 * @see woffice/inc/helpers.php
		 *
		 * @param mixed $option_value - the value returned by the database
		 * @param string $option - the option name
		 * @param mixed $default - the default value
		 */
		return apply_filters( 'woffice_get_settings_option', $option_value, $option, $default );
	}
}

	/**
	 * create shortcode
	 *
	 * @param string $option
	 * @param string $option
	 *
	 * @return Adds a new shortcode.
	 */

	if(!function_exists('woffice_create_shortcode')) {
		function woffice_create_shortcode($shortcode_name,$shortcode_callback) {
			add_shortcode($shortcode_name, $shortcode_callback);
		}
	}
		/**
		 * register widget
		 *
		 * @param string $option
		 * @param string $option
		 *
		 * @return register mew widget
		 */
	if(!function_exists('woffice_register_new_widget')){
		function woffice_register_new_widget($widget_name){
			if(!empty($widget_name)){
				register_widget($widget_name);
			}
		}
	}
	
		/**
		 * Return HTTPS Protocol
		 */
	if(!function_exists('woffice_get_https_protocol')) {
		function woffice_get_https_protocol() {
			return isset($_SERVER['HTTPS']) ? $_SERVER['HTTPS'] : '';
		}
	}
	
		/**
		 * Return HTTP_HOST
		 */
	if(!function_exists('woffice_get_http_host')) {
		function woffice_get_http_host() {
			return isset($_SERVER['HTTP_HOST']) ? $_SERVER['HTTP_HOST'] : '';
		}
	}
	
		/**
		 * Return REQUEST_URI
		 */
	if(!function_exists('woffice_get_request_uri')) {
		function woffice_get_request_uri() {
			return isset($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI'] : '';
		}
	}
	
		/**
		 * Return REQUEST_METHOD
		 */
	if(!function_exists('woffice_get_request_method')) {
		function woffice_get_request_method() {
			return isset($_SERVER['REQUEST_METHOD']) ? $_SERVER['REQUEST_METHOD'] : '';
		}
	}
	
		/**
		 * Return REQUEST_METHOD
		 */
	if(!function_exists('woffice_get_remote_addr')) {
		function woffice_get_remote_addr() {
			return isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : '';
		}
	}

		/**
		 * Return SERVER_PORT
		 */
	if(!function_exists('woffice_get_remote_port')) {
		function woffice_get_remote_port() {
			return isset($_SERVER['SERVER_PORT']) ? $_SERVER['SERVER_PORT'] : '';
		}
	}
		/**
		 * echo output
		 */
	if(!function_exists('woffice_echo_output')) {
		function woffice_echo_output($data) {
			echo $data;
		}
	}
	/*
	* Whitelabel
	*/

function woffice_whitlabel_scripts(){
	if(defined('WOFFICE_WHITELABEL') && WOFFICE_WHITELABEL === true && defined('WOFFICE_WHITELABEL_NAME') &&  WOFFICE_WHITELABEL_NAME !== ''){
		$myslug = WOFFICE_WHITELABEL_NAME;
    	wp_enqueue_script( 
	        'woffice_white_front',
	        plugins_url( '', __FILE__ ) . '/libs/assets/js/woffice-whitelabel.js',
	        array('jquery')
	     );
	    $translation_array = array(
		    'myslug' => $myslug
		 );
	 	wp_localize_script( 'woffice_white_front', 'whitelabel', $translation_array );
	}
}
	
add_action('admin_enqueue_scripts','woffice_whitlabel_scripts');
add_action('wp_enqueue_scripts','woffice_whitlabel_scripts');

if(!function_exists('woffice_update_membermaps_coordinates')) {
	function woffice_update_membermaps_coordinates() {
		$map_center = function_exists('fw_get_db_ext_settings_option') && fw_ext('woffice-map') ? fw_get_db_ext_settings_option('woffice-map', 'map_center') : '';
		$map_key = function_exists('fw_get_db_ext_settings_option') && fw_ext('woffice-map') ? fw_get_db_ext_settings_option('woffice-map', 'map_api') : '';
		if(!empty($map_key) && isset($map_center['coordinates']) && empty($map_center['coordinates'])){
			$request = wp_remote_get("https://maps.google.com/maps/api/geocode/json?address=kenya&sensor=false&key=" . $map_key);
			$response = wp_remote_retrieve_body( $request );
			$json_decoded = json_decode($response);
			$output = $json_decoded->results;
			$lang = isset($output[0]) ? $output[0] : false;
			
			$lat = isset($lang->geometry->location->lat) ? $lang->geometry->location->lat : false;
			$lng = isset($lang->geometry->location->lng) ? $lang->geometry->location->lng : false;
			
			$locations_update = array(
				'coordinates' => array(
						'lat' => $lat,
						'lng' => $lng
					)
				);
			fw_set_db_ext_settings_option('woffice-map','map_center',$locations_update);
		}

		$directorymap_center = function_exists('fw_get_db_ext_settings_option') && fw_ext('woffice-directory') ? fw_get_db_ext_settings_option('woffice-directory', 'map_center') : '';
		$directorymap_key = function_exists('fw_get_db_ext_settings_option') && fw_ext('woffice-directory') ? fw_get_db_ext_settings_option('woffice-directory', 'map_api') : '';
		if(!empty($directorymap_key) && isset($directorymap_center['coordinates']) && empty($directorymap_center['coordinates'])){
			$request = wp_remote_get("https://maps.google.com/maps/api/geocode/json?address=kenya&sensor=false&key=" . $directorymap_key);
			$response = wp_remote_retrieve_body( $request );
			$json_decoded = json_decode($response);
			$output = $json_decoded->results;
			$lang = isset($output[0]) ? $output[0] : false;
			
			$lat = isset($lang->geometry->location->lat) ? $lang->geometry->location->lat : false;
			$lng = isset($lang->geometry->location->lng) ? $lang->geometry->location->lng : false;
			
			$locations_update = array(
				'coordinates' => array(
						'lat' => $lat,
						'lng' => $lng
					)
				);
			fw_set_db_ext_settings_option('woffice-directory','map_center',$locations_update);
		}
	}
	add_action('admin_init','woffice_update_membermaps_coordinates');
}

/*
* Woffice Credit system include
*/
if (!function_exists('Woffice_credit_system')) {
	/**
	 * Get the Woffice Credit system  extension
	 *
	 */
	function Woffice_credit_system() 
	{
		require plugin_dir_path( __FILE__ ) .'woffice-credit-system/woffice-credits.php';

	}
}
add_action('after_setup_theme','Woffice_credit_system');

function woffice_render_widget_view($file_path, $view_variables = array(), $return = true ) {

	if ( ! is_file( $file_path ) ) {
		return '';
	}

	extract( $view_variables, EXTR_REFS );
	unset( $view_variables );

	if ( $return ) {
		ob_start();
		require $file_path;

		return ob_get_clean();
	} else {
		require $file_path;
	}

	return '';
}

function woffice_is_extension_active($extension){

	$extensions = get_option('fw_active_extensions');

	if(!empty($extensions)){
		if(array_key_exists($extension,$extensions)) {
			return true;
		} else {
			return false;
		}
	}
}

if(!function_exists('woffice_get_post_option')) {
	/**
	 * Get the option from Unyson meta for a given post
	 *
	 * @param int $post_id
	 * @param string $option
	 * @param string $default
	 *
	 * @return mixed|null|string
	 */
	function woffice_get_post_option($post_id, $option, $default = ''){

	    $post_type = get_post_type( $post_id );

		if( function_exists('woffice_bp_is_buddypress') && woffice_bp_is_buddypress() && $post_type == 'page' ) {
			$bp_post_id = woffice_get_relative_current_buddypress_page_id( true );

			if( $bp_post_id ) {
				$post_id = $bp_post_id;
			}
		}

		$option_value = ( function_exists( 'fw_get_db_post_option' ) ) ? fw_get_db_post_option($post_id, $option) : $default;

        /**
         * Overrides returned from the function woffice_get_post_option( $post_id, $option )
         *
         * @see woffice/inc/helpers.php
         *
         * @param mixed $option_value - the value returned by the database
         * @param int $post_id - the post ID
         * @param string $option - the option name
         * @param mixed $default - the default value
         */
		return apply_filters( 'woffice_get_post_option', $option_value, $post_id, $option, $default );

	}
}

/*
 * validate option migration of yep/nope to boolean
 *
 * @param option which contain yep/nope
 *
 * @return boolean
 */
if(!function_exists('woffice_unyson_switch_to_bool')) {

    function woffice_unyson_switch_to_bool($option) {
        
        $result = '';

        if($option == 'yep' || $option == 'show' ) {
            $result = true;
        }

        if($option == 'none' || $option == 'hide' || $option == 'nope') {
            $result = false;
        }

        return $result;
    }
}

/**
 * This file contains all functions used by Woffice.
 * They're available in any PHP script loaded when the Woffice theme is enabled
 * All functions can be overwritten by a child theme
 * @author Xtendify
 */

 if(!function_exists('woffice_get_theming_option')) {
	/**
	 * Get an option from the theme settings
	 *
	 * @param string $option
	 * @param string $default
	 *
	 * @return mixed|null|string
	 */
	function woffice_get_theming_option($option, $default = ''){
        
        $theme_settings_options = get_option('woffice_theme_options');

		$option_value = isset($theme_settings_options[$option]) ? $theme_settings_options[$option] : $default;

        /**
         * Overrides the value returned from the function woffice_get_theming_option($option)
         *
         * @see woffice/inc/helpers.php
         *
         * @param mixed $option_value - the value returned by the database
         * @param string $option - the option name
         * @param mixed $default - the default value
         */
		return apply_filters( 'woffice_get_theming_option', $option_value, $option, $default );

	}
}
if(!function_exists('woffice_load_theme_demo')){
	function woffice_load_theme_demo() {
		
		if ( !class_exists( 'OCDI_Plugin' ) && file_exists( WOFFICE_CORE_PATH . 'libs/one-click-demo-import/one-click-demo-import.php' ) ) {
			require_once(WOFFICE_CORE_PATH . 'libs/one-click-demo-import/one-click-demo-import.php');
			require_once(WOFFICE_CORE_PATH . 'libs/extender/ocdi/ocdi-extender.php');
			require_once(WOFFICE_CORE_PATH . 'theme-options/demo-import.php' );
		}
	}
	add_action('plugins_loaded','woffice_load_theme_demo');
}

if(!function_exists('woffice_formatbyte_to_size')){
	function woffice_formatbyte_to_size($type,$size) {
		$units = array('B', 'KB', 'MB', 'GB', 'TB');
		$precision = 2;
		$bytes = max($size, 0);
		$pow = floor(($bytes ? log($bytes) : 0) / log(1024));
		$pow = min($pow, count($units) - 1);

		if($type == 'outputsize') {
			return round($bytes / (pow(1024, $pow)), $precision) . ' ' . $units[$pow];
		} else if($type == 'comparesize'){
			return round($bytes / (pow(1024, $pow)), $precision);
		}
	}
}