<?php
/**
 * MU Plugin: AH Index Uploads (create attachments for existing files)
 */
if (!defined('ABSPATH')) exit;

add_action('init', function () {
    if (!is_user_logged_in() || !current_user_can('administrator')) return;
    if (!isset($_GET['ah_index_uploads']) || $_GET['ah_index_uploads'] !== '1') return;

    @set_time_limit(0);
    @ini_set('memory_limit', '512M');

    $upload = wp_upload_dir();
    $basedir = $upload['basedir'];

    // Dossiers directement sous uploads (tes dossiers clients)
    $client_dirs = glob($basedir . '/*', GLOB_ONLYDIR);
    if (!$client_dirs) wp_die('Aucun dossier trouvé dans uploads.');

    require_once ABSPATH . 'wp-admin/includes/image.php';

    $created = 0; $skipped = 0;

    foreach ($client_dirs as $dirPath) {
        $folder = basename($dirPath);

        // fichiers dans le dossier
        $files = glob($dirPath . '/*');
        if (!$files) continue;

        foreach ($files as $filePath) {
            if (is_dir($filePath)) continue;

            $relative = $folder . '/' . basename($filePath);
            $type = wp_check_filetype(basename($filePath), null);
            if (empty($type['type'])) { $skipped++; continue; }

            // Déjà indexé ?
            $existing = get_posts([
                'post_type' => 'attachment',
                'fields' => 'ids',
                'posts_per_page' => 1,
                'meta_key' => '_wp_attached_file',
                'meta_value' => $relative,
            ]);
            if ($existing) { $skipped++; continue; }

            $attachment = [
                'post_mime_type' => $type['type'],
                'post_title' => sanitize_text_field(pathinfo($filePath, PATHINFO_FILENAME)),
                'post_status' => 'inherit',
                'guid' => $upload['baseurl'] . '/' . str_replace('%2F','/', rawurlencode($relative)),
            ];

            $attach_id = wp_insert_attachment($attachment, $filePath);
            if (is_wp_error($attach_id) || !$attach_id) { $skipped++; continue; }

            update_post_meta($attach_id, '_wp_attached_file', $relative);

            // metadata images
            $meta = wp_generate_attachment_metadata($attach_id, $filePath);
            if ($meta) wp_update_attachment_metadata($attach_id, $meta);

            $created++;
        }
    }

    wp_die("Index terminé — attachments créés: {$created} | ignorés: {$skipped}");
});
