<?php
if (!defined('ABSPATH')) exit;

add_filter('acf/load_field/name=categorie_taux', function($field) {

    // ID dynamique de la page "administration"
    $post_source_id = function_exists('arc_get_administration_page_id')
        ? arc_get_administration_page_id()
        : 0;

    // Si pas de page source ou ACF absent, on laisse le champ tel quel
    if (!$post_source_id || !function_exists('get_field')) {
        return $field;
    }

    $categories = get_field('categories_de_ventes', $post_source_id);

    // Réinitialise la liste des choix
    $field['choices'] = [];

    // Ajoute une option vide tout en haut
    $field['choices'][''] = '—';

    if (!empty($categories) && is_array($categories)) {
        foreach ($categories as $cat) {

            // Sécurise au cas où $cat n'est pas un tableau
            if (!is_array($cat)) continue;

            $acronyme = trim($cat['acronyme_categorie_vente'] ?? '');
            $nom      = trim($cat['nom_categorie_vente'] ?? '');

            // Utilise l’acronyme s’il existe, sinon le nom
            if ($acronyme !== '') {
                $field['choices'][$acronyme] = $acronyme;
            } elseif ($nom !== '') {
                $field['choices'][$nom] = $nom;
            }
        }
    }

    return $field;
});
