<?php

if (!function_exists('ah_user_is_admin_or_code_maitre_anniv')) {
    function ah_user_is_admin_or_code_maitre_anniv(): bool {
        if (current_user_can('administrator')) return true;

        $u = wp_get_current_user();
        if (!$u || empty($u->roles)) return false;

        $allowed_role_slugs = ['code_maitre','code-maitre','codemaitre'];

        foreach ($allowed_role_slugs as $r) {
            if (in_array($r, $u->roles, true)) return true;
        }
        return false;
    }
}

add_shortcode('anniversaires_clients', function() {

    $can_see_all = ah_user_is_admin_or_code_maitre_anniv();
    $uid = get_current_user_id();

    // 1) On récupère tous les clients (tu peux remettre ton filtre type_de_contact ici si besoin)
    $clients = get_posts([
        'post_type'      => 'clients',
        'post_status'    => 'publish',
        'posts_per_page' => -1,
        'orderby'        => 'title',
        'order'          => 'ASC',
        // Si tu veux aussi filtrer "Client" comme dans l'autre code, décommente :
        /*
        'meta_query' => [
            [
                'key'     => 'type_de_contact',
                'value'   => 'Client',
                'compare' => 'LIKE',
            ]
        ]
        */
    ]);

    if (!$clients) return '<p>Aucun client trouvé.</p>';

    // 2) ✅ Filtre par attribution si pas admin/code maître
    if (!$can_see_all) {
        $clients = array_values(array_filter($clients, function($client) use ($uid) {
            $saved = get_post_meta($client->ID, 'conseillers_manual', true);
            if (!is_array($saved)) return false;

            foreach ($saved as $v) {
                if ((int)$v === (int)$uid) return true; // attribué ou co-attribué
            }
            return false;
        }));

        if (!$clients) return '<p>Aucun client trouvé.</p>';
    }

    $today = new DateTime();
    $anniversaires = [];

    foreach ($clients as $client) {
        $dob_str = get_field('date_naissance_client_ag', $client->ID); // jj/mm/aaaa
        if (!$dob_str) continue;

        $dob = DateTime::createFromFormat('d/m/Y', $dob_str);
        if (!$dob) continue;

        $next_bday = DateTime::createFromFormat('d/m/Y', $dob->format('d/m/') . $today->format('Y'));
        if ($next_bday < $today) $next_bday->modify('+1 year');

        $age = (int)$next_bday->format('Y') - (int)$dob->format('Y');

        $anniversaires[] = [
            'date'  => $next_bday,
            'title' => get_the_title($client->ID),
            'link'  => get_permalink($client->ID),
            'age'   => $age
        ];
    }

    usort($anniversaires, fn($a,$b) => $a['date'] <=> $b['date']);
    $anniversaires = array_slice($anniversaires, 0, 10);

    ob_start();
    ?>
    <style>
    #toggleAnniversairesWrapper {border:1px solid #e2e8f0; border-radius:6px; overflow:hidden; margin-top:20px;}
    .toggle-header-anniversaires {display:flex; align-items:center; cursor:pointer; user-select:none; padding:12px 14px; width:100%; font-weight:600; font-size:1.2rem; text-transform:uppercase; color:#000; background-color:#fff; border-bottom:1px solid #e2e8f0;}
    .toggle-left-anniversaires {display:flex; align-items:center; gap:10px; flex:1 1 auto;}
    .toggle-header-anniversaires svg {width:18px; height:18px; transition: transform 0.3s ease;}
    .toggle-header-anniversaires.open svg {transform:rotate(180deg);}
    #toggleContentAnniversaires {max-height:0; opacity:0; padding:0 10px; overflow:hidden; transition:max-height 0.4s ease, opacity 0.3s ease, padding 0.3s ease;}
    #toggleContentAnniversaires.open {max-height:3000px; opacity:1; padding:10px;}

    #tableAnniversaires {border-collapse: collapse; width: 100%; margin: 20px 0; background: #fff; font-size: 14px; border: 1px solid #ccc; table-layout: fixed;}
    #tableAnniversaires th, #tableAnniversaires td {border-bottom: 1px solid #eee; text-align: center; padding: 5px; vertical-align: middle;}
    #tableAnniversaires thead th {background-color: #2271b1 !important; color: #fff; text-transform: uppercase; font-weight: 600; font-size: 16px; padding: 8px !important;}
    #tableAnniversaires td {height:35px; padding:5px;}
    </style>

    <div id="toggleAnniversairesWrapper">
        <div class="toggle-header-anniversaires" id="toggleHeaderAnniversaires">
            <div class="toggle-left-anniversaires">
                <svg viewBox="0 0 24 24" fill="currentColor"><path d="M7 10l5 5 5-5H7z"/></svg>
                <span>ANNIVERSAIRES</span>
            </div>
        </div>

        <div id="toggleContentAnniversaires">
            <table id="tableAnniversaires">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Client</th>
                        <th>Âge</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($anniversaires as $a): ?>
                        <tr>
                            <td><?php echo esc_html($a['date']->format('d/m/Y')); ?></td>
                            <td><a href="<?php echo esc_url($a['link']); ?>"><?php echo esc_html($a['title']); ?></a></td>
                            <td><?php echo esc_html($a['age']); ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>

    <script>
    (function(){
        const header = document.getElementById('toggleHeaderAnniversaires');
        const body = document.getElementById('toggleContentAnniversaires');
        header.addEventListener('click', () => {
            const open = body.classList.toggle('open');
            header.classList.toggle('open', open);
        });
    })();
    </script>
    <?php

    return ob_get_clean();
});
