<?php
if (!defined('ABSPATH')) exit;

add_filter('acf/load_field/name=avancement', function($field) {

    // ID dynamique de la page "administration"
    $source_id = function_exists('arc_get_administration_page_id')
        ? arc_get_administration_page_id()
        : 0;

    // Si pas de source ou ACF absent → on ne touche pas au champ
    if (!$source_id || !function_exists('get_field')) {
        return $field;
    }

    // Récupère le repeater 'procedure' depuis la page Administration
    $procedures = get_field('procedure', $source_id);

    // Valeur vide par défaut (comme ton code)
    $choices = ['' => ''];

    if (!empty($procedures) && is_array($procedures)) {
        foreach ($procedures as $row) {

            if (!is_array($row)) continue;

            $etape = $row['etapes'] ?? '';
            $etape = is_string($etape) ? trim($etape) : '';

            if ($etape !== '') {
                $choices[$etape] = $etape;
            }
        }
    }

    $field['choices'] = $choices;
    return $field;
});
