<?php

if (!function_exists('arc_get_page_id_by_path_cached')) {
    /**
     * Retourne l'ID d'une page par slug (path) avec cache option + cache statique.
     * Exemple path: 'conjoint' ou 'ajouter-un-enfant'
     */
    function arc_get_page_id_by_path_cached(string $path, string $option_key): int {

        static $mem = [];
        if (isset($mem[$option_key])) {
            return (int) $mem[$option_key];
        }

        $stored = (int) get_option($option_key, 0);
        if ($stored && get_post($stored)) {
            return $mem[$option_key] = $stored;
        }

        $page = get_page_by_path(trim($path, '/'));
        if ($page) {
            $id = (int) $page->ID;
            update_option($option_key, $id);
            return $mem[$option_key] = $id;
        }

        return $mem[$option_key] = 0;
    }
}

$arc_page_conjoint_id = arc_get_page_id_by_path_cached('conjoint', 'arc_page_conjoint_id');
$arc_page_enfant_id   = arc_get_page_id_by_path_cached('ajouter-un-enfant', 'arc_page_ajouter_enfant_id');


add_shortcode('bouton_conjoint', function() {
    ob_start();

    $post_id = get_the_ID();
    if (!$post_id) return '<p style="padding:10px;color:#777;">Impossible de déterminer le client.</p>';

    $prenom_client = trim(get_field('prenom_client_ag', $post_id));
    $nom_client    = trim(get_field('nom_client_ag', $post_id));
    if (!$prenom_client || !$nom_client) {
        return '<p style="padding:10px;color:#777;">Informations client incomplètes.</p>';
    }

    $purge_orphan = function($ids) {
        return array_filter($ids, function($id) {
            $p = get_post($id);
            return $p && $p->post_status === 'publish';
        });
    };

    // ==== CONJOINTS ====
    $conjoints_ids = get_field('conjoint_relation', $post_id) ?: [];
    $inverse_conj = get_posts([
        'post_type'      => 'clients',
        'posts_per_page' => -1,
        'post_status'    => 'publish',
        'fields'         => 'ids',
        'meta_query'     => [
            ['key' => 'conjoint_relation', 'value' => '"' . $post_id . '"', 'compare' => 'LIKE']
        ],
        'tax_query' => [
            ['taxonomy' => 'category','field'=>'slug','terms'=>['conjoint'],'operator'=>'IN']
        ]
    ]);
    $conjoints_ids = $purge_orphan(array_unique(array_merge($conjoints_ids, (array)$inverse_conj)));
    $conj_base = $arc_page_conjoint_id ? get_permalink($arc_page_conjoint_id) : home_url('/conjoint/');
$btn_url_conjoint = add_query_arg('parent_client', $post_id, $conj_base);


    // ==== ENFANTS ====
    $enfants_ids = get_field('enfants_relation', $post_id) ?: [];
    $inverse_enf = get_posts([
        'post_type'      => 'clients',
        'posts_per_page' => -1,
        'post_status'    => 'publish',
        'fields'         => 'ids',
        'meta_query'     => [
            ['key'=>'enfant_relation','value'=>'"'.$post_id.'"','compare'=>'LIKE']
        ],
        'tax_query'=>[
            ['taxonomy'=>'category','field'=>'slug','terms'=>['enfant'],'operator'=>'IN']
        ]
    ]);
    // Second parent
    $title_current = trim(get_the_title($post_id));
    $by_second_parent = [];
    if($title_current!==''){
        $by_second_parent = get_posts([
            'post_type'=>'clients','posts_per_page'=>-1,'post_status'=>'publish','fields'=>'ids',
            'meta_query'=>[['key'=>'nom_&_prenom_du_second_parent','value'=>$title_current,'compare'=>'=']],
            'tax_query'=>[['taxonomy'=>'category','field'=>'slug','terms'=>['enfant'],'operator'=>'IN']]
        ]);
    }
    $enfants_ids = $purge_orphan(array_unique(array_merge($enfants_ids,(array)$inverse_enf,(array)$by_second_parent)));
    $enf_base = $arc_page_enfant_id ? get_permalink($arc_page_enfant_id) : home_url('/ajouter-un-enfant/');
$btn_url_enfant = add_query_arg('parent_client', $post_id, $enf_base);


    // ==== OUTPUT HTML ====
    ?>
    <!-- Toggle CONJOINT -->
    <div class="famille-toggle-wrapper">

        <div class="famille-toggle-header open">

            <div class="toggle-left-users">
                <svg viewBox="0 0 24 24" fill="currentColor"><path d="M7 10l5 5 5-5H7z"/></svg>
                <span>CONJOINT</span>
            </div>
        </div>
        <div id="formulaire-conjoints" class="famille-toggle-content open" style="margin:20px">

            <?php if($conjoints_ids): ?>
                <div class="contrats-table-container">
                    <table class="contrats-table">
                        <thead><tr><th>NOM</th><th>PRÉNOM</th><th>DATE DE NAISSANCE</th><th>FICHE</th></tr></thead>
                        <tbody>
                        <?php foreach($conjoints_ids as $cid):
                            $nom = get_field('nom_client_ag',$cid);
                            $prenom = get_field('prenom_client_ag',$cid);
                            $date_naissance = get_field('date_naissance_client_ag',$cid);
                            $permalink = get_permalink($cid);
                        ?>
                            <tr>
                                <td><?= esc_html($nom) ?></td>
                                <td><?= esc_html($prenom) ?></td>
                                <td><?= esc_html($date_naissance) ?></td>
                                <td><a href="<?= esc_url($permalink) ?>" target="_blank">🔗</a></td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <p class="placeholder">Aucun conjoint trouvé.</p>
            <?php endif; ?>
            <button id="btn-add-conjoint" class="btn-conjoint" style="margin-top:15px; padding:8px 14px; background:#2271b1; color:#fff; border:none; border-radius:4px; cursor:pointer;">➕ CRÉER UNE FICHE CONJOINT</button>
        </div>
    </div>

    <!-- Toggle ENFANTS -->
    <div class="famille-toggle-wrapper">

        <div class="famille-toggle-header open">

            <div class="toggle-left-users">
                <svg viewBox="0 0 24 24" fill="currentColor"><path d="M7 10l5 5 5-5H7z"/></svg>
                <span>ENFANTS</span>
            </div>
        </div>
<div id="formulaire-enfants" class="famille-toggle-content open" style="margin:20px">

            <?php if($enfants_ids): ?>
                <div class="contrats-table-container">
                    <table class="contrats-table">
                        <thead><tr><th>NOM</th><th>PRÉNOM</th><th>DATE DE NAISSANCE</th><th>FICHE</th></tr></thead>
                        <tbody>
                        <?php foreach($enfants_ids as $eid):
                            $nom = get_field('nom_client_ag',$eid);
                            $prenom = get_field('prenom_client_ag',$eid);
                            $date_naissance = get_field('date_naissance_client_ag',$eid);
                            $permalink = get_permalink($eid);
                        ?>
                            <tr>
                                <td><?= esc_html($nom) ?></td>
                                <td><?= esc_html($prenom) ?></td>
                                <td><?= esc_html($date_naissance) ?></td>
                                <td><a href="<?= esc_url($permalink) ?>" target="_blank">🔗</a></td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <p class="placeholder">Aucun enfant trouvé.</p>
            <?php endif; ?>
            <button id="btn-add-enfant" class="btn-enfant" style="margin-top:15px; padding:8px 14px; background:#2271b1; color:#fff; border:none; border-radius:4px; cursor:pointer; text-transform:uppercase;">➕ CRÉER UNE FICHE ENFANT</button>
        </div>
    </div>

<script>
document.addEventListener('DOMContentLoaded', function() {

    /* ---------- TOGGLES ---------- */
  document.querySelectorAll('.famille-toggle-header').forEach(header => {

    const wrapper  = header.closest('.famille-toggle-wrapper');
    const content  = wrapper.querySelector('.famille-toggle-content');

    header.addEventListener('click', () => {
        const isOpen = content.classList.contains('open');

        if (isOpen) {
            content.style.maxHeight = '0';
        } else {
            content.style.maxHeight = content.scrollHeight + 'px';
        }

        content.classList.toggle('open', !isOpen);
        header.classList.toggle('open', !isOpen);
    });

    // initial
    if (content.classList.contains('open')) {
        content.style.maxHeight = content.scrollHeight + 'px';
    }
});


    /* ---------- BOUTONS CREATION ---------- */
    const btnConjoint = document.getElementById('btn-add-conjoint');
    if (btnConjoint) {
        btnConjoint.addEventListener('click', function() {
            window.location.href = "<?= esc_url($btn_url_conjoint) ?>";
        });
    }

    const btnEnfant = document.getElementById('btn-add-enfant');
    if (btnEnfant) {
        btnEnfant.addEventListener('click', function() {
            window.location.href = "<?= esc_url($btn_url_enfant) ?>";
        });
    }

});
</script>

    <?php

    return ob_get_clean();
});



// Pré-remplir enfant_relation uniquement sur /ajouter-un-enfant/
add_filter('acf/load_value/name=enfant_relation', function($value, $post_id, $field) {
    if (!empty($value)) return $value; // si déjà rempli, ne rien faire
    if (is_admin()) return $value; // éviter admin
    if (strpos($_SERVER['REQUEST_URI'], '/ajouter-un-enfant') !== false && !empty($_GET['parent_client'])) {
        $value = [ intval($_GET['parent_client']) ];
    }
    return $value;
}, 10, 3);

// Pré-remplir conjoint_relation uniquement sur /conjoint/
add_filter('acf/load_value/name=conjoint_relation', function($value, $post_id, $field) {
    if (!empty($value)) return $value;
    if (is_admin()) return $value;
    if (strpos($_SERVER['REQUEST_URI'], '/conjoint') !== false && !empty($_GET['parent_client'])) {
        $value = [ intval($_GET['parent_client']) ];
    }
    return $value;
}, 10, 3);



// -------------------- save_post_clients --------------------
add_action('save_post_clients', function($post_id, $post, $update) {

    // protections
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    if (wp_is_post_revision($post_id)) return;
    if ($post->post_type !== 'clients') return;

    // on ignore la suppression
    if ($post->post_status === 'trash') return;

    // IDs pages pour détecter source
$create_conjoint_post_id = (int) $arc_page_conjoint_id;
$create_enfant_post_id   = (int) $arc_page_enfant_id;


    // détecter parent_client via GET
    $parent_client = isset($_GET['parent_client']) ? intval($_GET['parent_client']) : 0;

    // détecter source via referer
    $referer = wp_get_referer() ?: '';
    $is_from_conjoint_page = false;
    $is_from_enfant_page   = false;

    if ($referer) {
       $conj_url = $create_conjoint_post_id ? get_permalink($create_conjoint_post_id) : '';
$enf_url  = $create_enfant_post_id ? get_permalink($create_enfant_post_id) : '';

if ($conj_url && strpos($referer, $conj_url) !== false) $is_from_conjoint_page = true;
if ($enf_url  && strpos($referer, $enf_url)  !== false) $is_from_enfant_page   = true;

    }

    // fallback : catégorie enfant/conjoint
    $terms = wp_get_post_terms($post_id, 'category', ['fields'=>'slugs']);
    if (!$is_from_conjoint_page && !$is_from_enfant_page && !empty($terms)) {
        if (in_array('enfant', $terms)) $is_from_enfant_page = true;
        if (in_array('conjoint', $terms)) $is_from_conjoint_page = true;
    }

    // -------------------- Gérer relations parent/enfant/conjoint --------------------
    if ($parent_client && $parent_client !== intval($post_id)) {
        // enfant
        if ($is_from_enfant_page) {
            $parent_enfants = get_field('enfants_relation', $parent_client) ?: [];
            if (!in_array($post_id, $parent_enfants)) {
                $parent_enfants[] = $post_id;
                update_field('enfants_relation', $parent_enfants, $parent_client);
            }
            $child_parents = get_field('enfant_relation', $post_id) ?: [];
            if (!in_array($parent_client, $child_parents)) {
                $child_parents[] = $parent_client;
                update_field('enfant_relation', $child_parents, $post_id);
            }
        }

        // conjoint
        if ($is_from_conjoint_page) {
            $parent_conjoints = get_field('conjoint_relation', $parent_client) ?: [];
            if (!in_array($post_id, $parent_conjoints)) {
                $parent_conjoints[] = $post_id;
                update_field('conjoint_relation', $parent_conjoints, $parent_client);
            }
            $child_conj = get_field('conjoint_relation', $post_id) ?: [];
            if (!in_array($parent_client, $child_conj)) {
                $child_conj[] = $parent_client;
                update_field('conjoint_relation', $child_conj, $post_id);
            }
        }
    }

    // 2) Second parent
    $second_parent_label = get_field('nom_&_prenom_du_second_parent', $post_id);
    if (!empty($second_parent_label)) {
        $second_parent_label = trim($second_parent_label);
        $q = new WP_Query([
            'post_type' => 'clients',
            'posts_per_page' => 1,
            'post_status' => 'publish',
            's' => $second_parent_label,
            'fields' => 'ids'
        ]);
        $found_id = 0;
        foreach ($q->posts as $cand_id) {
            if (trim(get_the_title($cand_id)) === $second_parent_label) {
                $found_id = intval($cand_id);
                break;
            }
        }
        wp_reset_postdata();

        if ($found_id && $found_id !== intval($post_id)) {
            $second_parent_enfants = get_field('enfants_relation', $found_id) ?: [];
            if (!in_array($post_id, $second_parent_enfants)) {
                $second_parent_enfants[] = $post_id;
                update_field('enfants_relation', $second_parent_enfants, $found_id);
            }
            $child_parents = get_field('enfant_relation', $post_id) ?: [];
            if (!in_array($found_id, $child_parents)) {
                $child_parents[] = $found_id;
                update_field('enfant_relation', $child_parents, $post_id);
            }
        }
    }

}, 10, 3);


// -------------------- Historique ACF automatique --------------------

// Conjoint
add_filter('acf/update_value/name=conjoint_relation', function($value, $post_id, $field) {

    if (empty($value) || !is_array($value)) return $value;

    $historique = get_field('historique_rep', 'option') ?: [];

    foreach ($value as $parent_id) {
        $historique[] = [
            'historique_sous' =>  '<span style="margin-right:12px;">👥</span>' . '<span style="margin-right:8px;">' . 'Création d\'une fiche conjoint pour ' . get_the_title($parent_id) . ' (' . get_the_title($post_id) . ')' . '</span>',
            'timestamp' => current_time('Y-m-d H:i:s'),
        ];
    }

    update_field('historique_rep', $historique, 'option');

    return $value;
}, 10, 3);

// Enfant
add_filter('acf/update_value/name=enfant_relation', function($value, $post_id, $field) {

    if (empty($value) || !is_array($value)) return $value;

    $historique = get_field('historique_rep', 'option') ?: [];

    foreach ($value as $parent_id) {
        $historique[] = [
            'historique_sous' =>  '<span style="margin-right:12px;">🧒</span>' . '<span style="margin-right:8px;">' . 'Création d\'une fiche enfant pour ' . get_the_title($parent_id) . ' (' . get_the_title($post_id) . ')' . '</span>',
            'timestamp' => current_time('Y-m-d H:i:s'),
        ];
    }

    // Second parent
    $second_parent_label = get_field('nom_&_prenom_du_second_parent', $post_id);
    if (!empty($second_parent_label)) {
        $second_parent_label = trim($second_parent_label);

        $q = new WP_Query([
            'post_type' => 'clients',
            'posts_per_page' => 1,
            'post_status' => 'publish',
            's' => $second_parent_label,
            'fields' => 'ids'
        ]);
        $candidates = $q->posts;
        $found_id = 0;
        foreach ($candidates as $cand_id) {
            if (trim(get_the_title($cand_id)) === $second_parent_label) {
                $found_id = intval($cand_id);
                break;
            }
        }
        wp_reset_postdata();

        if ($found_id && $found_id !== intval($post_id)) {
            $historique[] = [
                'historique_sous' => 'Création d\'une fiche enfant pour ' . get_the_title($found_id) . ' (' . get_the_title($post_id) . ')',
                'timestamp' => current_time('Y-m-d H:i:s'),
            ];
        }
    }

    update_field('historique_rep', $historique, 'option');

    return $value;
}, 10, 3);
