<?php
if (!defined('ABSPATH')) exit;

add_action('init', 'arc_register_cpts', 0);

function arc_register_cpts(): void {

    $common = [
        'public'       => true,
        'has_archive'  => true,
        'menu_icon'    => 'dashicons-portfolio',
        'supports'     => ['title', 'editor', 'thumbnail'],
        'show_in_rest' => true,
        'taxonomies'   => ['post_tag', 'category'],
    ];

    // Clients
    arc_register_cpt('clients', 'Clients', 'Client', 'clients', $common);

    // Conformité
    arc_register_cpt('conformite', 'Conformité', 'Conformité', 'conformite', $common);

    // Contrats
    arc_register_cpt('contrats', 'Contrats', 'Contrat', 'contrats', $common);

    // Contrats avec UCS (post_type sans tiret !)
    arc_register_cpt('contrats-avec-ucs', 'Contrats avec UCS', 'Contrat avec UCS', 'contrats-avec-ucs', $common);

    // Contrats hors agrégation
    arc_register_cpt('contrats_hag', 'Contrats hors agrégation', 'Contrat hors agrégation', 'contrats_hag', $common);

    // Cotations
    arc_register_cpt('cotations', 'Cotations', 'Cotation', 'cotations', $common);

    // Nouvelle vente
    arc_register_cpt('nouvelle_vente', 'Nouvelles ventes', 'Nouvelle vente', 'nouvelle_vente', $common);
}

/**
 * Helper CPT centralisé
 */
function arc_register_cpt(string $post_type, string $name, string $singular, string $slug, array $common_args = []): void {

    $args = array_merge($common_args, [
        'labels' => [
            'name'          => $name,
            'singular_name' => $singular,
            'menu_name'     => $name,
        ],
        'rewrite' => ['slug' => $slug],
    ]);

    register_post_type($post_type, $args);
}
