<?php

add_action('acf/save_post', function($post_id) {

    if (get_post_type($post_id) !== 'clients') return;

    // Nom du repeater et sous-champs
    $repeater_key = 'lettre'; // ou 'field_661e6790cd8b2'
    $file_key     = 'lettre_fichiers'; // ou field key exacte
    $date_key     = 'date_lettre';     // ou field key exacte

    $lettres = get_field($repeater_key, $post_id);

    if (!empty($lettres) && is_array($lettres)) {
        $updated = false;

        foreach ($lettres as $i => $row) {
            if (!empty($row[$file_key]) && empty($row[$date_key])) {
                $lettres[$i][$date_key] = date_i18n('d/m/Y');
                $updated = true;
            }
        }

        if ($updated) {
            update_field($repeater_key, $lettres, $post_id);
        }
    }

}, 20);