<?php

add_shortcode('encadre_conformite', function() {

    $post_id = get_the_ID();
    if (!$post_id) return '';

    /* ======= Champs à vérifier ======= */
    $repeater_map = [
        'der'        => ['label' => 'DER', 'sub' => 'der_fichiers'],
        'cni'        => ['label' => 'Pièce d’identité', 'sub' => 'cni_fichiers'],
        'rib'        => ['label' => 'RIB', 'sub' => 'rib_fichiers'],
        'justif'     => ['label' => 'Justificatif de domicile', 'sub' => 'justif_fichiers'],
        'lettre'     => ['label' => 'Lettre de mission', 'sub' => 'lettre_fichiers'],
        'situation'  => ['label' => 'Situation patrimoniale', 'sub' => 'situation_fichiers'],
    ];

    $total_fields = count($repeater_map);
    $filled_count = 0;
    $docs_status = [];
    $date_suivi = null;

    /* ======= Parcours des champs ======= */
    foreach ($repeater_map as $key => $data) {
        $rows = get_field($key, $post_id);
        $has_file = false;

        if (is_array($rows) && !empty($rows)) {
            foreach ($rows as $row) {
                $value = $row[$data['sub']] ?? null;
                if (!$value) continue;

                if (is_array($value) && !empty($value['ID'])) {
                    $path = get_attached_file($value['ID']);
                    if ($path && file_exists($path) && filesize($path) > 1024) {
                        $has_file = true;
                        break;
                    }
                } elseif (is_numeric($value)) {
                    $path = get_attached_file($value);
                    if ($path && file_exists($path) && filesize($path) > 1024) {
                        $has_file = true;
                        break;
                    }
                }
            }
        }

        $docs_status[] = [
            'key'   => $key,
            'label' => $data['label'],
            'valid' => $has_file
        ];

        if ($has_file) $filled_count++;
    }

    /* ======= Récupération date réelle du fichier lettre ======= */
    $rows_lettre = get_field('lettre', $post_id);

    if (is_array($rows_lettre) && !empty($rows_lettre)) {
        foreach ($rows_lettre as $row) {
            if (!empty($row['lettre_fichiers']['ID'])) {
                $fichier_id = $row['lettre_fichiers']['ID'];
                $path = get_attached_file($fichier_id);

                if ($path && file_exists($path)) {

                    $timestamp = filemtime($path);

                    $date_obj = new DateTime("@$timestamp");
                    $date_obj->setTimezone(new DateTimeZone('Europe/Paris'));
                    $date_obj->modify('+1 year');

                    $date_suivi = $date_obj->format('d/m/Y');
                    break;
                }
            }
        }
    }

    /* ======= Pourcentage ======= */
    $pourcentage = round(($filled_count / $total_fields) * 100);

    /* ======= Historique seulement si on passe à 100% ======= */
    $prev_pourcentage = get_post_meta($post_id, '_conformite_pourcentage', true) ?: 0;

    if ($prev_pourcentage < 100 && $pourcentage >= 100) {

        $client_title = get_the_title($post_id);

        $saved_conseillers = get_post_meta($post_id, 'conseillers_manual', true);
        $conseillers_list = '-';
        if (!empty($saved_conseillers) && is_array($saved_conseillers)) {
            $lines = [];
            foreach ($saved_conseillers as $uid) {
                $user = get_userdata($uid);
                if ($user) $lines[] = $user->display_name;
            }
            $conseillers_list = implode(', ', array_filter($lines));
        }

        $message =                    '<span style="margin-right:12px;">✅</span>'
                      . '<span style="margin-right:8px;">' . esc_html($client_title) . ' est maintenant conforme à 100% ' . '</span>' 
                      . '<span style="font-size:0.85em; margin-left:5px;">(' . esc_html($conseillers_list) . ')</span>';

        $historique_options = get_field('historique_rep', 'option') ?: [];
        $historique_options[] = [
            'historique_sous' => $message,
            'timestamp'       => current_time('Y-m-d H:i:s'),
        ];

        update_field('historique_rep', $historique_options, 'option');
    }

    update_post_meta($post_id, '_conformite_pourcentage', $pourcentage);

    /* ======= Couleur radial ======= */
    if ($pourcentage < 50) {
        $color = '#e63946';
    } elseif ($pourcentage < 80) {
        $color = '#f4a261';
    } else {
        $color = '#2a9d8f';
    }

    /* ======= HTML ======= */
    ob_start();
    ?>
    <style>
    .encadre-conformite { border: 1px solid #e2e8f0; border-radius: 8px; box-shadow: 0 3px 6px rgba(0,0,0,0.06); margin-top: 20px; background: #fff; font-family: Arial, Helvetica, sans-serif; }
    .titre-bleu { display: flex; align-items: center; gap: 10px; background-color: #2271b1; color: #fff; font-weight: 700; padding: 10px 14px; font-size: 1.05rem; text-transform: uppercase; border-radius: 6px 6px 0 0; }
    .titre-bleu .infos-arrow { width: 18px; height: 18px; flex-shrink: 0; color: #fff; }
    .radial-wrapper { display: flex; justify-content: center; align-items: center; margin: 25px 0; }
    .radial-chart { width: 120px; height: 120px; }
    .circle-bg { fill: none; stroke: #eee; stroke-width: 3.8; }
    .circle { fill: none; stroke-width: 3.8; stroke-linecap: round; transform: rotate(-90deg); transform-origin: center; animation: progress 0.6s ease-out forwards; }
    .percentage { fill: #111; font-size: 0.58em; font-weight: 700; text-anchor: middle; font-family: "Helvetica Neue", Arial, sans-serif; }
    @keyframes progress { 0% { stroke-dasharray: 0 100; } }
    .separator.full { border: none; border-top: 1px solid #e2e8f0; margin: 20px 0; width: 100%; }
    .details-conformite { padding: 0 16px 16px; text-align: left; color: #111; }
    .bloc-detail { margin-top: 15px; }
    .sous-titre { display: inline-block; font-weight: 700; text-transform: uppercase; color: #000; font-size: 1.05rem; font-family: 'Open Sans', Arial, Helvetica, sans-serif; }
    .count { display: block; margin-top: 8px; font-size: 0.95rem; color: #111; font-weight: 500; }
    .prochain-suivi { margin-top: 6px; font-size: 0.95rem; font-weight: 500; display: block; }
    .liste-docs { margin-top: 12px; margin-left: 15px; font-style: italic; }
    .doc-ligne { display: flex; align-items: center; gap: 8px; margin: 6px 0; line-height: 1.3; }
    .statut { width: 20px; text-align: center; font-weight: 700; }
    .statut.ok { color: #2a9d8f; }
    .statut.nok { color: #e63946; }
    .nom-doc { color: #111; flex: 1; }
    </style>

    <div class="encadre-conformite">
        <div class="titre-bleu" role="heading" aria-level="3">
            <svg viewBox="0 0 24 24" class="infos-arrow" aria-hidden="true"><path d="M9 6l6 6-6 6"/></svg>
            <span>Conformité</span>
        </div>

        <div class="radial-wrapper" style="--accent: <?php echo $color; ?>;">
            <svg viewBox="0 0 36 36" class="radial-chart">
                <path class="circle-bg" d="M18 2.0845 a15.9155 15.9155 0 0 1 0 31.831 a15.9155 15.9155 0 0 1 0 -31.831"/>
                <path class="circle" stroke="<?php echo $color; ?>" stroke-dasharray="<?php echo $pourcentage; ?>, 100" d="M18 2.0845 a15.9155 15.9155 0 0 1 0 31.831 a15.9155 15.9155 0 0 1 0 -31.831"/>
                <text x="18" y="20.35" class="percentage"><?php echo $pourcentage; ?>%</text>
            </svg>
        </div>

        <div class="separator full"></div>

        <div class="details-conformite">

            <div class="bloc-detail">
                <span class="sous-titre">Conformité Vie / Retraite</span><br>
                <span class="count"><strong><?php echo "{$filled_count}/{$total_fields} documents renseignés"; ?></strong></span>

           <div class="liste-docs">
    <em>
    <?php foreach ($docs_status as $doc): ?>
        <div class="doc-ligne">
            <span class="statut <?php echo $doc['valid'] ? 'ok' : 'nok'; ?>"><?php echo $doc['valid'] ? '✓' : '✗'; ?></span>
            <span class="nom-doc"><?php echo esc_html($doc['label']); ?></span>
        </div>
    <?php endforeach; ?>
    </em>
</div>

<?php if ($date_suivi): ?>
    <span class="count prochain-suivi"><strong><br>Prochain suivi conseillé le :</strong> <?php echo $date_suivi; ?></span>
<?php endif; ?>

            </div>

            <div class="separator full"></div>

            <div class="bloc-detail">
                <span class="sous-titre">Conformité IARD</span><br>
                <strong>À venir...</strong>
            </div>
        </div>
    </div>
    <?php

    return ob_get_clean();
});
