<?php

function arc_get_logo_attachment_id(string $logo_slug): int {
    return (int) get_option('arc_logo_id_' . $logo_slug, 0);
}

function arc_get_logo_url(string $logo_slug, string $size = 'full'): string {
    $id = arc_get_logo_attachment_id($logo_slug);
    if (!$id) return '';
    $src = wp_get_attachment_image_src($id, $size);
    return $src ? $src[0] : '';
}