<?php
if (!defined('ABSPATH')) exit;

add_action('frontend_admin/save_post', 'sync_categories_administration_final', 10, 2);

function sync_categories_administration_final($form, $post_id) {

    // ID dynamique de la page /administration/
    $source_id = function_exists('arc_get_administration_page_id')
        ? (int) arc_get_administration_page_id()
        : 0;

    // Exécuter uniquement sur la page Administration
    if (!$source_id || (int) $post_id !== $source_id) {
        return;
    }

    // Si ACF absent, on sort (sinon fatal sur get_field/update_field)
    if (!function_exists('get_field') || !function_exists('update_field') || !function_exists('delete_field')) {
        return;
    }

    // Lire le premier répéteur
    $categories = get_field('categories_de_ventes', $post_id);
    if (empty($categories) || !is_array($categories)) {
        return;
    }

    // Supprimer complètement l'ancien contenu du second répéteur
    delete_field('objectifs_cat_vente', $post_id);

    // Reconstruire le contenu à partir du premier répéteur
    $objectifs = [];

    foreach ($categories as $cat) {
        if (!is_array($cat)) continue;

        $nom = $cat['nom_categorie_vente'] ?? '';
        $nom = is_string($nom) ? trim($nom) : '';

        if ($nom !== '') {
            $objectifs[] = [
                'categorie_vente_obj' => $nom,
            ];
        }
    }

    // Mettre à jour le second répéteur
    if (!empty($objectifs)) {
        update_field('objectifs_cat_vente', $objectifs, $post_id);
    }
}
