<?php

add_action('init', function() {
    add_shortcode('objectifs_par_utilisateur', 'render_objectifs_par_utilisateur_shortcode');
});

function render_objectifs_par_utilisateur_shortcode($atts = []) {

    if (!function_exists('get_field') || !function_exists('update_field')) {
        return '<p>Le plugin ACF n\'est pas actif ou indisponible.</p>';
    }

    // ✅ ID dynamique de la page /administration/
    $post_source_id = function_exists('arc_get_administration_page_id')
        ? (int) arc_get_administration_page_id()
        : 0;

    if (!$post_source_id) {
        return '<p>Page Administration introuvable.</p>';
    }

    $categories = get_field('categories_de_ventes', $post_source_id);
    if (empty($categories) || !is_array($categories)) {
        return '<p>Aucune catégorie de vente définie.</p>';
    }

    $users = get_users([
    'orderby' => 'display_name',
    'order'   => 'ASC',
    'exclude' => [1],
]);
    if (empty($users)) {
        return '<p>Aucun utilisateur trouvé.</p>';
    }

    // Sauvegarde silencieuse
    $recharger_apres_save = false;
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['save_valeurs'])) {
        if (current_user_can('edit_users') || current_user_can('manage_options')) {
            $vals = isset($_POST['valeurs']) && is_array($_POST['valeurs']) ? $_POST['valeurs'] : [];
            $sanitized = [];
            foreach ($vals as $uid => $row) {
                $uid = intval($uid);
                if ($uid <= 0) continue;
                foreach ($row as $k => $v) {
                    $sanitized[$uid][sanitize_text_field($k)] = $v === '' ? '' : floatval($v);
                }
            }

            if (function_exists('update_field')) {
                $ok = update_field('objectifs_par_utilisateur', $sanitized, 'option');
            }
            if (empty($ok)) {
                update_option('objectifs_par_utilisateur_raw', $sanitized);
            }

            $recharger_apres_save = true;
        }
    }

    $saved_values = get_field('objectifs_par_utilisateur', 'option');
    if (empty($saved_values)) {
        $saved_values = get_option('objectifs_par_utilisateur_raw', []);
    }
    if (!is_array($saved_values)) $saved_values = [];

    ob_start();
    ?>

<style>
/* ----- TOGGLE HEADER ----- */
.toggle-header-users {
  display: flex;
  align-items: center;
  justify-content: space-between;
  cursor: pointer;
  user-select: none;
  padding: 12px 14px;
  width: 100%;
  font-weight: 600;
  font-size: 1.2rem;
  text-transform: uppercase;
  color: #000;
  background-color: #fff;
  border: none;
  border-bottom: 1px solid #ccc; /* ✅ affiné à 1px pour correspondre aux autres */
  transition: background-color 0.25s ease, box-shadow 0.25s ease;
}
.toggle-header-users:hover {
  background-color: rgba(0,0,0,0.04);
  box-shadow: 0 1px 4px rgba(0,0,0,0.08);
}
.toggle-left-users {
  display: flex;
  align-items: center;
  gap: 10px;
  flex: 1 1 auto;
  padding-right: 10px;
  position: relative;
}
.toggle-header-users svg {
  width: 18px;
  height: 18px;
  transition: transform 0.3s ease;
}
.toggle-header-users.open svg {
  transform: rotate(180deg);
}
.toggle-info-users {
  flex: 0 0 auto;
  color: #2271b1;
  position: relative;
  cursor: default;
  margin-left: 10px;
}
.toggle-info-users::after {
  content: "Saisissez les objectifs de chaque utilisateur pour chaque catégorie de vente.";
  position: absolute;
  right: 0;
  top: 130%;
  width: 250px;
  background: #fff;
  color: #333;
  border: 1px solid #ccc;
  padding: 8px 10px;
  border-radius: 6px;
  font-size: 0.9rem;
  line-height: 1.3;
  font-weight: normal;
  text-transform: none;
  box-shadow: 0 2px 8px rgba(0,0,0,0.1);
  opacity: 0;
  pointer-events: none;
  transition: opacity 0.3s ease;
  z-index: 999;
}
.toggle-info-users:hover::after {
  opacity: 1;
}

/* ----- TOGGLE ANIMATION ----- */
#formulaire-objectifs-utilisateur {
  transition: max-height 0.4s ease, opacity 0.3s ease;
  overflow: hidden;
  opacity: 0;
  max-height: 0;
}
#formulaire-objectifs-utilisateur.open {
  opacity: 1;
  max-height: 9999px;
}

/* ----- TABLEAU ----- */
table.valeurs-cats {
  border-collapse: collapse;
  width: calc(100% - 40px);
  margin: 20px;
  background: #fff;
  font-size: 14px;
  line-height: 30px;
  border: 1px solid #ccc;
  box-sizing: border-box;
  table-layout: auto;
}
table.valeurs-cats thead th {
  background-color: #2271b1 !important;
  color: #fff;
  text-transform: uppercase;
  font-weight: 600;
  font-size: 16px;
  padding: 10px !important;
}
table.valeurs-cats th,
table.valeurs-cats td {
  border: 1px solid #eee;
  text-align: center;
  padding: 0 10px !important;
  height: 30px;
  line-height: 30px;
  vertical-align: middle;
  box-sizing: border-box;
}
/* ✅ Bordure droite restaurée */
table.valeurs-cats th:last-child,
table.valeurs-cats td:last-child {
  border-right: 1px solid #ccc !important;
}
table.valeurs-cats td:first-child {
  text-align: center;
  font-weight: 600;
  text-transform: uppercase;
  color: #333;
  background: #f8f8f8;
  width: 200px;
}

/* ----- INPUTS ----- */
table.valeurs-cats input[type="number"] {
  width: 100%;
  height: 30px !important;
  font-size: 14px !important;
  line-height: 30px !important;
  padding: 0 !important;
  margin: 0 !important;
  background: transparent;
  border: none;
  text-align: center;
  box-sizing: border-box !important;
  -webkit-appearance: none;
  appearance: none;
  transition: none !important;
}
table.valeurs-cats input[type="number"]:focus {
  outline: none !important;
  background: #eef6fc;
}

/* ----- BOUTON VALIDER ----- */
form .button-validate {
  margin-top: 15px;
  padding: 10px 15px;
  background-color: #2271b1;
  border: none;
  border-radius: 4px;
  color: #fff;
  font-weight: 600;
  cursor: pointer;
  font-size: 14px;
  transition: background-color 0.2s ease;
}
form .button-validate:hover {
  background-color: #1c5f91;
}
</style>

<div class="toggle-header-users open" id="toggleHeaderUsers">
  <div class="toggle-left-users">
    <svg viewBox="0 0 24 24" fill="currentColor">
      <path d="M7 10l5 5 5-5H7z"/>
    </svg>
    <span>Objectifs par utilisateur</span>
  </div>
  <div class="toggle-info-users">ℹ️</div>
</div>

<div id="formulaire-objectifs-utilisateur" class="open">
  <form method="post" novalidate>
    <table class="valeurs-cats" role="table" aria-label="Objectifs par utilisateur">
      <thead>
        <tr>
          <th>Utilisateur</th>
          <?php foreach ($categories as $cat): ?>
            <th><?= esc_html($cat['acronyme_categorie_vente'] ?: $cat['nom_categorie_vente']); ?></th>
          <?php endforeach; ?>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($users as $user): ?>
          <tr>
            <td><?= esc_html($user->display_name); ?></td>
            <?php foreach ($categories as $cat):
              $field_key = 'val_' . sanitize_title($cat['acronyme_categorie_vente'] ?: $cat['nom_categorie_vente']);
              $val = isset($saved_values[$user->ID][$field_key]) ? $saved_values[$user->ID][$field_key] : '';
            ?>
              <td>
                <input type="number" step="any" name="valeurs[<?= esc_attr($user->ID); ?>][<?= esc_attr($field_key); ?>]" value="<?= esc_attr($val); ?>">
              </td>
            <?php endforeach; ?>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>

    <p style="text-align:right; margin-right:20px;">
      <button type="submit" name="save_valeurs" class="button-validate">VALIDER</button>
    </p>
  </form>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
  const header = document.getElementById('toggleHeaderUsers');
  const form = document.getElementById('formulaire-objectifs-utilisateur');
  if (!header || !form) return;

  let ouvert = true;
  form.classList.add('open');

  header.addEventListener('click', (e) => {
    if (e.target.closest('.toggle-info-users')) return;
    ouvert = !ouvert;
    header.classList.toggle('open', ouvert);
    form.classList.toggle('open', ouvert);
  });

  if (window.history.replaceState) {
    window.history.replaceState(null, null, window.location.href);
  }

  <?php if ($recharger_apres_save): ?>
  setTimeout(() => { window.location.reload(); }, 400);
  <?php endif; ?>
});
</script>

<?php
    return ob_get_clean();
}