<?php

if (!function_exists('calculate_completion_percentage2')) {
    function calculate_completion_percentage2($post_id) {

        if (wp_is_post_revision($post_id) || (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)) {
            return;
        }

        // ---- CONFIG ----
        $repeater_fields = [
            'der'        => 'der_fichiers',
            'cni'        => 'cni_fichiers',
            'rib'        => 'rib_fichiers',
            'justif'     => 'justif_fichiers',
            'lettre'     => 'lettre_fichiers',
            'situation'  => 'situation_fichiers',
        ];
        $target_field = 'sum';
        // ----------------

        $filled_count = 0;

        foreach ($repeater_fields as $repeater => $subfield) {
            $rows = get_field($repeater, $post_id);
            $has_file = false;

            if (is_array($rows) && !empty($rows)) {
                foreach ($rows as $row) {
                    $value = $row[$subfield] ?? null;

                    if (is_array($value) && !empty($value['url'])) {
                        $path = get_attached_file($value['ID']);
                        if ($path && file_exists($path) && filesize($path) > 1024) {
                            $has_file = true;
                            break;
                        }
                    } elseif (is_numeric($value)) {
                        $path = get_attached_file($value);
                        if ($path && file_exists($path) && filesize($path) > 1024) {
                            $has_file = true;
                            break;
                        }
                    }
                }
            }

            if ($has_file) {
                $filled_count++;
            }
        }

        // Map filled fields → percentage
        $percentages = [0, 17, 33, 50, 67, 83, 100];
        $completion  = isset($percentages[$filled_count]) ? (int)$percentages[$filled_count] : 0;
        $final_value = "{$completion}%";

        // Update ACF field
        $field_obj = get_field_object($target_field, $post_id);
        $field_key = $field_obj['key'] ?? $target_field;
        update_field($field_key, $final_value, $post_id);

        error_log("✅ Conformité calculée : {$final_value} ({$filled_count}/" . count($repeater_fields) . ") pour le post #{$post_id}");

        return $final_value;
    }
}

// Hook : exécution après chaque sauvegarde de post
add_action('save_post_post', function($post_id) {
    add_action('shutdown', function() use ($post_id) {
        if (function_exists('calculate_completion_percentage2')) {
            calculate_completion_percentage2($post_id);
        }
    });
}, 999);