<?php

function toggle_shortcode($atts, $content = null) {
    $atts = shortcode_atts([
        'title' => 'Toggle',
        'filigrane' => 'yes',
    ], $atts, 'toggle');

    $toggleId = 'toggle_' . uniqid();
    $contentId = 'toggleContent_' . uniqid();

    ob_start(); ?>
    <div class="contrats-toggle-wrapper" id="<?php echo $toggleId; ?>">
        <div class="toggle-header-users open" data-target="<?php echo $contentId; ?>">
            <div class="toggle-left-users">
                <svg viewBox="0 0 24 24" fill="currentColor"><path d="M7 10l5 5 5-5H7z"/></svg>
                <span><?php echo esc_html($atts['title']); ?></span>
            </div>
        </div>
        <div id="<?php echo $contentId; ?>" class="toggle-content open <?php echo ($atts['filigrane']==='no')?'no-filigrane':''; ?>">
            <?php echo $content; ?>
        </div>
    </div>
    <?php
    return ob_get_clean();
}
add_shortcode('toggle', 'toggle_shortcode');




// -------------------------
// CSS commun pour tous les toggles
function toggle_assets() { ?>
<style>
.toggle-header-users {display:flex; align-items:center; cursor:pointer; user-select:none; padding:12px 14px; width:100%; font-weight:600; font-size:1.2rem; text-transform:uppercase; color:#000; background-color:#fff; border-bottom:1px solid #e2e8f0; transition: background-color 0.25s ease, box-shadow 0.25s ease;}
.toggle-header-users:hover {background-color: rgba(0,0,0,0.04); box-shadow:0 1px 4px rgba(0,0,0,0.08);}
.toggle-left-users {display:flex; align-items:center; gap:10px; flex:1 1 auto;}
.toggle-header-users svg {width:18px; height:18px; transition: transform 0.3s ease;}
.toggle-header-users.open svg {transform:rotate(180deg);}
.contrats-toggle-wrapper {border:1px solid #e2e8f0; border-radius:6px; overflow:hidden; margin-top:20px; position:relative;}
.toggle-content {overflow:hidden; max-height:3000px; opacity:1; padding:10px; transition:max-height 0.5s ease, opacity 0.5s ease;}
.toggle-content.closed {max-height:0; opacity:0; padding:0 10px;}
.rappels-table {width:100%; border-collapse: collapse; font-size:14px; table-layout:auto;margin-bottom:10px;}
.rappels-table th, .rappels-table td {padding:8px 12px; border-bottom:1px solid #ccc;}
.rappels-table th {background: rgba(208,231,255,0.5); font-weight:700;}
.rappels-table tbody tr:nth-child(even) td {background: rgba(208,231,255,0.3);}
.rappels-table tbody tr:nth-child(odd) td {background: #ffffff;}
.rappels-table::before {content:"PLACEHOLDER"; position:absolute; top:50%; left:50%; transform:translate(-50%,-50%) rotate(-25deg); font-size:80px; font-weight:900; color: rgba(0,0,0,0.06); pointer-events:none; z-index:1; user-select:none; white-space:nowrap;}
.rappels-table.no-filigrane::before { content: none; }
/* Pagination type liste clients */
.pagination-wrapper {display:flex; justify-content:center; align-items:center; margin:15px 0 30px; gap:6px; font-family: Arial, sans-serif;}
.pagination-wrapper span {display:inline-block; padding:6px 10px; background-color:#f0f0f0; color:#333; cursor:pointer; border-radius:4px; font-weight:500; user-select:none; transition: all 0.2s ease;}
.pagination-wrapper span.active {background-color:#2271b1; color:#fff; font-weight:700;}
.pagination-wrapper span:hover:not(.active){background-color:#d1e4fc;}
.pagination-wrapper span.disabled{background-color:#eee;color:#aaa;cursor:default;}
</style>
<?php }
add_action('wp_footer','toggle_assets');



add_shortcode('rappels_toggle', function() {
    if(!is_user_logged_in()) return '<p>Connectez-vous pour voir vos rappels.</p>';

    ob_start();

    $today = strtotime('today');
    $next_week = strtotime('+7 days');
    $user_id = get_current_user_id();

    $clients = get_posts([
        'post_type' => 'clients',
        'numberposts' => -1,
        'post_status' => 'publish',
        'fields' => 'ids',
    ]);

    $rappels = [];

    foreach($clients as $client_id) {
        // Récupère les conseillers assignés
        $saved_conseillers = get_post_meta($client_id, 'conseillers_manual', true);
        if(!is_array($saved_conseillers) || !in_array($user_id, $saved_conseillers)) continue;

        $suivi = get_field('suivi_client', $client_id);
        if(!$suivi || !is_array($suivi)) continue;

        foreach($suivi as $row) {
            $date_str = $row['date_suivi_client'] ?? '';
            $type = $row['type_suivi_client'] ?? ''; // ✅ le champ qui doit filtrer
            $avancement = $row['avancement'] ?? '';
            $note = $row['notes_suivi_client'] ?? '';

            // Parse date "dd/mm/yyyy"
            if($date_str) {
                $date_parts = explode('/', $date_str);
                if(count($date_parts) === 3) {
                    $date_ts = mktime(0,0,0, (int)$date_parts[1], (int)$date_parts[0], (int)$date_parts[2]);
                } else {
                    $date_ts = false;
                }
            } else {
                $date_ts = false;
            }

            // ✅ Filtre : Type = Rappel (Avancement n'a plus d'impact)
            if($date_ts && $type === 'Rappel' && $date_ts >= $today && $date_ts <= $next_week) {
                $rappels[] = [
                    'date' => $date_str,
                    'client' => get_the_title($client_id),
                    'client_link' => get_permalink($client_id),
                    'tache' => $avancement, // tu peux aussi mettre $type si tu veux afficher "Rappel"
                    'type' => $type,
                    'notes' => $note,
                    'ts' => $date_ts
                ];
            }
        }
    }

    // Tri par date
    usort($rappels, function($a,$b){ return $a['ts'] <=> $b['ts']; });

    ?>
    <table class="rappels-table no-filigrane" style="width:100%;">
        <thead>
            <tr>
                <th style="width:15%;">Date</th>
                <th style="width:35%;">Client</th>
                <th style="width:10%;">Tâche</th>
                <th style="width:40%;">Notes</th>
            </tr>
        </thead>
        <tbody>
            <?php
            if(empty($rappels)) {
                echo '<tr><td colspan="4" style="text-align:center;">Aucun rappel cette semaine</td></tr>';
            } else {
                foreach($rappels as $rappel) {
                    echo "<tr>";
                    echo "<td>{$rappel['date']}</td>";
                    echo "<td><a href='{$rappel['client_link']}'>{$rappel['client']}</a></td>";
                    echo "<td>{$rappel['tache']}</td>";
                    echo "<td>{$rappel['notes']}</td>";
                    echo "</tr>";
                }
            }
            ?>
        </tbody>
    </table>
    <?php

    $count = count($rappels);
    $title = "Vous avez {$count} rappel" . ($count>1?"s":"") . " cette semaine";

    return do_shortcode('[toggle title="'.esc_html($title).'"]'.ob_get_clean().'[/toggle]');
});









add_shortcode('infos_toggle', function() {
    if(!function_exists('get_field')) return '<p>ACF requis.</p>';

    // Parser des timestamps robustes
$parse_ts = function($raw) {
    if(!$raw) return 0;

    // Si c’est un int unix direct
    if(is_numeric($raw)) {
        $n = (int)$raw;
        if($n > 1000000000000) $n = floor($n/1000); // ms → sec
        return $n;
    }

    // On crée un DateTime avec timezone WordPress
    try {
        $dt = new DateTime($raw, wp_timezone()); // wp_timezone() renvoie timezone WP
        return $dt->getTimestamp();
    } catch(Exception $e) {
        return 0;
    }
};



    // Récupère le repeater
    $rows = get_field('historique_rep', 'option');

    if(!$rows || !is_array($rows)) {
        return do_shortcode('[toggle title="Dernières informations" filigrane="no"]Aucune information récente[/toggle]');
    }

    // Nettoyage & parsing timestamps
    $clean = [];
    foreach($rows as $r) {
        $text_raw = $r['historique_sous'] ?? '';
        $ts_raw = $r['timestamp'] ?? '';

        $ts = $parse_ts($ts_raw);
        if($ts <= 0) continue; // ignore invalid timestamps

        // garder l'original text (sanitize plus bas)
        $clean[] = [
            'text' => $text_raw,
            'ts' => $ts,
        ];
    }

    if(empty($clean)) {
        return do_shortcode('[toggle title="Dernières informations" filigrane="no"]Aucune information récente[/toggle]');
    }

    // Tri du plus récent au plus ancien
    usort($clean, function($a, $b){ return $b['ts'] - $a['ts']; });

    // Garder les 10 premières (les plus récentes)
    // ❌ [SUPPRESSION NECESSAIRE POUR PAGINATION] $clean = array_slice($clean, 0, 10);

    // Allowed HTML tags pour le champ historique_sous
    $allowed_tags = [
        'a' => ['href' => true, 'title' => true, 'target' => true, 'rel' => true],
        'br' => [],
        'strong' => [],
        'b' => [],
        'em' => [],
        'i' => [],
        'span' => ['class' => true, 'style' => true],
    ];

    // Build table (no zebra, no filigrane). On override le background pour supprimer toute alternance CSS.
    ob_start();
    ?>
    <style>
    /* Override local pour forcer suppression de backgrounds/zebra sur ce tableau */
    .rappels-table.no-filigrane.no-zebra,
    .rappels-table.no-filigrane.no-zebra tbody tr,
    .rappels-table.no-filigrane.no-zebra td {
        background: transparent !important;
    }
    .rappels-table.no-filigrane.no-zebra td {
        padding: 10px 12px;
    }
    .rappels-table.no-filigrane.no-zebra td span.histo-date {
        font-size:0.85em;
        color:#666;
        margin-left:6px;
        vertical-align:middle;
    }
    </style>

    <!-- AJOUT 1 : ID pour pagination -->
    <table class="rappels-table no-filigrane no-zebra" style="width:100%;" id="infosTable">
        <tbody>
            <?php foreach($clean as $row): 
                $text_raw = $row['text'];
                $ts = (int)$row['ts'];

                // formattage humain
                $now = time();
                $diff = $now - $ts;
                if($diff < 86400) {
                    if($diff < 60) {
                        $date = "il y a {$diff} sec";
                    } elseif($diff < 3600) {
                        $date = "il y a " . floor($diff/60) . " min";
                    } else {
                        $date = "il y a " . floor($diff/3600) . " h";
                    }
                } else {
                    $date = date('d/m/Y', $ts);
                }

                // sanitize le HTML autorisé (laisse span inline)
                $text_safe = wp_kses($text_raw, $allowed_tags);
            ?>
                <tr>
                    <td>
                        <?php echo $text_safe; ?>
                        <span class="histo-date">(<?php echo esc_html($date); ?>)</span>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <!-- AJOUT 2 : container pagination -->
    <div class="pagination-wrapper" id="infosPagination"></div>

    <!-- AJOUT 3 : SCRIPT PAGINATION EXACTEMENT COMME TON MODELE -->
    <script>
    document.addEventListener('DOMContentLoaded', function(){
        const table = document.getElementById('infosTable');
        const tbody = table.querySelector('tbody');
        const pagination = document.getElementById('infosPagination');
        const perPage = 10;
        let currentPage = 1;

        // Convertit le tableau PHP → JS
        const data = Array.from(tbody.querySelectorAll('tr')).map(tr => tr.outerHTML);

        function renderTable(page = 1){
            tbody.innerHTML = '';
            const start = (page - 1) * perPage;
            data.slice(start, start + perPage).forEach(html => {
                tbody.insertAdjacentHTML('beforeend', html);
            });
            renderPagination();
        }

        function renderPagination(){
            pagination.innerHTML = '';
            const totalPages = Math.ceil(data.length / perPage);

            const createSpan = (text, pageNum, disabled=false, active=false)=>{
                const sp = document.createElement('span');
                sp.textContent = text;
                if(disabled) sp.classList.add('disabled');
                if(active) sp.classList.add('active');
                if(!disabled && !active){
                    sp.addEventListener('click', ()=>{ currentPage = pageNum; renderTable(pageNum);});
                }
                return sp;
            };

            const visiblePages = 3;
            let startPage = Math.max(1, currentPage - Math.floor(visiblePages/2));
            let endPage   = Math.min(totalPages, startPage + visiblePages - 1);
            if(endPage - startPage < visiblePages - 1)
                startPage = Math.max(1, endPage - visiblePages + 1);

            pagination.appendChild(createSpan('DÉBUT',1,currentPage===1));
            pagination.appendChild(createSpan('«',currentPage-1,currentPage===1));

            for(let i = startPage; i <= endPage; i++){
                pagination.appendChild(createSpan(i,i,false,i===currentPage));
            }

            pagination.appendChild(createSpan('»',currentPage+1,currentPage===totalPages));
            pagination.appendChild(createSpan('FIN',totalPages,currentPage===totalPages));
        }

        renderTable();
    });
    </script>

    <?php
    return do_shortcode('[toggle title="Dernières informations" filigrane="no"]'.ob_get_clean().'[/toggle]');
});



add_shortcode('mes_ventes_toggle', function() {
    if(!function_exists('get_field')) return '<p>ACF requis.</p>';
    $current_user = wp_get_current_user();
    $user_name = $current_user->display_name;
    $ventes = get_posts(['post_type'=>'post','posts_per_page'=>-1,'post_status'=>'publish']);
    $ventes = array_filter($ventes,function($v) use($user_name){
        $mandataire=get_field('mandataire',$v->ID); $acc1=get_field('accompagnant',$v->ID); $acc2=get_field('second_accompagnant',$v->ID);
        return in_array($user_name,array_filter([$mandataire,$acc1,$acc2]));
    });
    $ventes=array_slice($ventes,0,10);

    ob_start();
    ?>
    <table class="rappels-table no-filigrane">
        <thead><tr><th>Date</th><th>Client</th><th>Volume signé (€)</th></tr></thead>
        <tbody>
            <?php
            foreach($ventes as $i=>$v){
                $id=$v->ID;
                $date=get_field('date_du_jour',$id)?:'-';
                $client=trim(get_field('prenom_du_client',$id).' '.get_field('nom_du_client',$id))?:'-';
                $volume=number_format(floatval(get_field('volume_total_signe',$id)),2,',',' ');
                $row_color = ($i%2==0)?"#ffffff":"rgba(208,231,255,0.3)";
                echo "<tr style='background:{$row_color};'><td>{$date}</td><td>{$client}</td><td>{$volume}</td></tr>";
            }
            ?>
        </tbody>
    </table>
    <?php
    return do_shortcode('[toggle title="Mes dernières ventes" filigrane="no"]'.ob_get_clean().'[/toggle]');
});



add_shortcode('meilleures_performances_actions', function() {
    $posts = get_posts([
        'post_type' => 'cotations',
        'posts_per_page' => 2,
        'orderby' => 'date',
        'order' => 'DESC'
    ]);
    if(count($posts)<2) return '<p>Pas assez de cotations pour calculer les performances.</p>';

    $latest = $posts[0];
    $previous = $posts[1];

$latest_rows = get_field('cotations', $latest->ID) ?: [];
$prev_rows   = get_field('cotations', $previous->ID) ?: [];

// --- NOUVEAU : récupération des ISIN UC à exclure ---
$ucs_rows = get_field('contrats_ucs', 'option') ?: [];
$ucs_isin_to_exclude = [];
foreach($ucs_rows as $u){
    if(!empty($u['isin_ucs'])){
        $ucs_isin_to_exclude[] = trim($u['isin_ucs']);
    }
}
// -----------------------------------------------------

$perf_data = [];
$prev_map = [];

foreach($prev_rows as $row){
    $isin = $row['isin'] ?? null;
    if(!$isin) continue;
    $prev_map[$isin] = floatval(str_replace(['€',' '],'',str_replace(',', '.',$row['valeur_cotation_euro']??0)));
}

foreach($latest_rows as $row){
    $isin = $row['isin'] ?? null;
    if(!$isin) continue;

    // ---- FILTRE UC ----
    if(in_array($isin, $ucs_isin_to_exclude)) continue;
    // -------------------

    $latest_val = floatval(str_replace(['€',' '],'',str_replace(',', '.',$row['valeur_cotation_euro']??0)));
    $prev_val = $prev_map[$isin] ?? null;

    if($prev_val===null || $prev_val==0) continue;

    $perf_data[] = [
        'isin' => $isin,
        'action' => $row['libelle'] ?? $isin,
        'evolution' => (($latest_val - $prev_val) / $prev_val) * 100
    ];
}


    usort($perf_data, fn($a,$b)=>$b['evolution']<=>$a['evolution']);
    $per_page=10;

    ob_start(); ?>
    <div class="contrats-toggle-wrapper">
        <div class="toggle-header-users open">
            <div class="toggle-left-users">
                <svg viewBox="0 0 24 24" fill="currentColor"><path d="M7 10l5 5 5-5H7z"/></svg>
                <span>Les meilleures performances cette semaine</span>
            </div>
        </div>
        <div class="toggle-content open">
            <table class="rappels-table no-filigrane" id="perfTableActions" style="padding:10px;">
                <thead><tr><th>Classement</th><th>Code ISIN</th><th>Action</th><th style="cursor:pointer;" id="sortEvolutionActions">Évolution ▲▼</th></tr></thead>
                <tbody></tbody>
            </table>
            <div class="pagination-wrapper" id="perfPagination"></div>
        </div>
    </div>
    <script>
    document.addEventListener('DOMContentLoaded', function(){
        // Pagination & tri pour perf_data
        const table=document.getElementById('perfTableActions');
        if(!table) return;
        const tbody=table.querySelector('tbody');
        const header=document.getElementById('sortEvolutionActions');
        const perPage=<?=$per_page?>;
        let asc=false, currentPage=1;
        const data=<?php echo json_encode($perf_data);?>;

        function renderTable(page=1){
            tbody.innerHTML='';
            const start=(page-1)*perPage;
            data.slice(start,start+perPage).forEach((item,i)=>{
                const color=item.evolution>=0?'green':'red';
                const tr=document.createElement('tr');
                tr.innerHTML=`<td>${start+i+1}</td><td>${item.isin}</td><td>${item.action}</td><td style="color:${color}" data-evo="${item.evolution}">${item.evolution>=0?'+':''}${item.evolution.toFixed(2)}%</td>`;
                tbody.appendChild(tr);
            });
            renderPagination();
        }
function renderPagination(){
    const pagination = document.getElementById('perfPagination');
    pagination.innerHTML = '';
    const totalPages = Math.ceil(data.length / perPage);
    const createSpan = (text, pageNum, disabled=false, active=false) => {
        const sp = document.createElement('span');
        sp.textContent = text;
        if(disabled) sp.classList.add('disabled');
        if(active) sp.classList.add('active');
        if(!disabled && !active) sp.addEventListener('click',()=>{ currentPage=pageNum; renderTable(pageNum); });
        return sp;
    };

    const visiblePages = 3;
    let startPage = Math.max(1, currentPage - Math.floor(visiblePages/2));
    let endPage = Math.min(totalPages, startPage + visiblePages - 1);
    if(endPage - startPage < visiblePages - 1) startPage = Math.max(1, endPage - visiblePages + 1);

    // DÉBUT et <<
    pagination.appendChild(createSpan('DÉBUT', 1, currentPage===1));
    pagination.appendChild(createSpan('«', currentPage-1, currentPage===1));

    // Pages visibles
    for(let i=startPage; i<=endPage; i++){
        pagination.appendChild(createSpan(i, i, false, i===currentPage));
    }

    // >> et FIN
    pagination.appendChild(createSpan('»', currentPage+1, currentPage===totalPages));
    pagination.appendChild(createSpan('FIN', totalPages, currentPage===totalPages));
}


        header.addEventListener('click',()=>{asc=!asc; data.sort((a,b)=>asc?a.evolution-b.evolution:b.evolution-a.evolution); currentPage=1; renderTable();});
        renderTable();

        // Tous les toggles smooth
        document.querySelectorAll('.toggle-header-users').forEach(header=>{
            const content=header.nextElementSibling;
            content.style.transition="max-height 0.4s ease, opacity 0.3s ease"; content.style.overflow="hidden";
            function openToggle(){requestAnimationFrame(()=>{content.style.maxHeight=content.scrollHeight+'px'; content.style.opacity=1;});}
            openToggle();
            header.addEventListener('click',()=>{
                header.classList.toggle('open');
                if(content.style.maxHeight && content.style.maxHeight!=="0px"){content.style.maxHeight="0px"; content.style.opacity=0;} else {openToggle();}
            });
        });
    });
    </script>
    <?php
    return ob_get_clean();
});



add_shortcode('filtres_avances_placeholder', function() {
    ob_start();
    ?>
    <style>
    /* Toggle Filtres Avancés */
    .contrats-toggle-wrapper {border:1px solid #e2e8f0; border-radius:6px; overflow:hidden; margin-top:20px;}
    .toggle-header-users {display:flex; align-items:center; cursor:pointer; user-select:none; padding:12px 14px; width:100%; font-weight:600; font-size:1.2rem; text-transform:uppercase; color:#000; background-color:#fff; border-bottom:1px solid #e2e8f0; transition: background-color 0.25s ease, box-shadow 0.25s ease;}
    .toggle-header-users:hover {background-color: rgba(0,0,0,0.04); box-shadow:0 1px 4px rgba(0,0,0,0.08);}
    .toggle-left-users {display:flex; align-items:center; gap:10px; flex:1 1 auto;}
    .toggle-header-users svg {width:18px; height:18px; transition: transform 0.3s ease;}
    .toggle-header-users.open svg {transform:rotate(180deg);}
    #toggleContentFiltres {transition: max-height 0.4s ease, opacity 0.3s ease, padding 0.3s ease; overflow: hidden; max-height:0; opacity:0; padding:0 10px;}
    #toggleContentFiltres.open {max-height:3000px; opacity:1; padding:10px;}
    </style>

    <div class="contrats-toggle-wrapper">
        <div class="toggle-header-users" id="toggleHeaderFiltres">
            <div class="toggle-left-users">
                <svg viewBox="0 0 24 24" fill="currentColor"><path d="M7 10l5 5 5-5H7z"/></svg>
                <span>FILTRES AVANCÉS</span>
            </div>
        </div>

        <div id="toggleContentFiltres">
            <p style="text-align:center; font-style:italic; color:#555;">Contenu des filtres à venir…</p>
        </div>
    </div>

    <script>
    (function(){
        const header = document.getElementById('toggleHeaderFiltres');
        const body = document.getElementById('toggleContentFiltres');
        header.addEventListener('click', () => {
            const open = body.classList.toggle('open');
            header.classList.toggle('open', open);
        });
    })();
    </script>
    <?php

    return ob_get_clean();
});



add_shortcode('rappels_user', function() {
    if(!is_user_logged_in()) return '0';

    $today = strtotime('today');
    $next_week = strtotime('+7 days');
    $current_user_id = get_current_user_id();
    $count = 0;

    $clients = get_posts([
        'post_type'   => 'clients',
        'numberposts' => -1,
        'post_status' => 'publish',
        'fields'      => 'ids',
    ]);

    foreach($clients as $client_id){
        $suivi = get_field('suivi_client', $client_id);
        $saved_conseillers = get_post_meta($client_id,'conseillers_manual',true);

        if(!$suivi || !is_array($suivi) || !is_array($saved_conseillers)) continue;
        if(!in_array($current_user_id, $saved_conseillers)) continue;

        foreach($suivi as $row){
            $date_str = $row['date_suivi_client'] ?? '';
            $type     = $row['type_suivi_client'] ?? ''; // ✅ filtre sur ce champ

            // ✅ on ignore Avancement, on filtre sur Type = Rappel
            if(!$date_str || $type !== 'Rappel') continue;

            $parts = explode('/', $date_str);
            if(count($parts) === 3){
                $date_ts = mktime(0,0,0,(int)$parts[1],(int)$parts[0],(int)$parts[2]);
                if($date_ts >= $today && $date_ts <= $next_week){
                    $count++;
                }
            }
        }
    }

    return "<div style='text-align:center; font-size:40px; font-weight:bold; color:#fff;'>{$count}</div>";
});


add_shortcode('periode_rappels', function() {

    $aujourdhui = current_time('d/m');                // JJ/MM aujourd'hui
    $dans_7_jours = date_i18n('d/m', strtotime('+7 days')); // JJ/MM dans 7 jours

    return "DU {$aujourdhui} AU {$dans_7_jours}";
});
