<?php
if (!defined('ABSPATH')) exit;

define('ARC_INSTALLER_VERSION', '1.0.0');

function arc_is_installed(): bool {
    return (bool) get_option('arc_installed');
}


add_action('admin_menu', function () {
    if (arc_is_installed()) {
        return;
    }

    add_management_page(
        'Initialisation du site',
        'Initialiser le site',
        'manage_options',
        'arc-installer',
        'arc_installer_page'
    );
});


function arc_installer_page() {
    if (!current_user_can('manage_options')) {
        return;
    }

    ?>
    <div class="wrap">
        <h1>Initialisation du site</h1>

        <p>
            Cette action est <strong>irréversible</strong>.
            Elle doit être lancée uniquement sur un site vierge.
        </p>

        <form method="post">
            <?php wp_nonce_field('arc_install'); ?>
            <input type="submit" name="arc_install" class="button button-primary" value="Initialiser le site">
        </form>
    </div>
    <?php
}

add_action('admin_init', function () {
    if (!isset($_POST['arc_install'])) {
        return;
    }

    if (!current_user_can('manage_options')) {
        return;
    }

    if (!check_admin_referer('arc_install')) {
        return;
    }

    if (arc_is_installed()) {
        return;
    }

    arc_run_installation();
});



function arc_run_installation() {

    error_log('[arc INSTALLER] Début installation');

    require_once arc_CORE_PATH . 'installer/pages.php';
    require_once arc_CORE_PATH . 'installer/menu.php';
    require_once arc_CORE_PATH . 'installer/options.php';
    require_once arc_CORE_PATH . 'installer/roles.php';
    require_once arc_CORE_PATH . 'installer/media.php';
    require_once ARH_CORE_PATH . 'installer/resolve-pages.php';

    arc_install_pages();
    arc_install_menu();
    arc_install_options();
    arc_install_roles();
    arh_install_media();
    arh_resolve_required_pages();

    update_option('arc_installed', 1);
    update_option('arc_installed_version', arc_INSTALLER_VERSION);

    error_log('[arc INSTALLER] Installation terminée');

    wp_redirect(admin_url());
    exit;
}
