<?php
if (!defined('ABSPATH')) exit;

function arc_install_pages() {

    $pages = [
        'dashboard' => [
            'title'   => 'Tableau de bord',
            'slug'    => 'dashboard',
            'content' => '<!-- wp:paragraph --><p>Bienvenue sur votre espace.</p><!-- /wp:paragraph -->'
        ],
        'profil' => [
            'title'   => 'Mon profil',
            'slug'    => 'mon-profil',
            'content' => ''
        ],
    ];

    foreach ($pages as $key => $page) {

        $option_key = 'arc_page_' . $key . '_id';
        $existing_id = get_option($option_key);

        if ($existing_id && get_post($existing_id)) {
            continue;
        }

        $id = wp_insert_post([
            'post_title'   => $page['title'],
            'post_name'    => $page['slug'],
            'post_content' => $page['content'],
            'post_status'  => 'publish',
            'post_type'    => 'page'
        ]);

        if (!is_wp_error($id)) {
            update_option($option_key, $id);
        }
    }
}
