<?php
if (!defined('ABSPATH')) exit;

function arc_resolve_required_pages() {
    // key => slug
    $required = [
        'administration' => 'administration',
    ];

    foreach ($required as $key => $slug) {
        $opt = 'arc_page_' . $key . '_id';

        $existing_id = (int) get_option($opt, 0);
        if ($existing_id && get_post($existing_id)) {
            continue;
        }

        $page = get_page_by_path($slug);
        if (!$page) {
            error_log('[arc INSTALLER] Page requise introuvable: /' . $slug . '/');
            // À toi de choisir: soit on continue, soit on bloque
            continue;
        }

        update_option($opt, (int) $page->ID);
        error_log('[arc INSTALLER] Page résolue: /' . $slug . '/ => ID ' . $page->ID);
    }
}
