<?php
/**
 * Template PDF Conformité – version PHP
 *
 * 
 */

if (!defined('ABSPATH')) {
    exit;
}

// ---------- Mapping "value checkbox ACF" => "ID image WP" ----------
// ⚠️ Mets ici la VALUE stockée par ACF (souvent la value, pas le label)
$logos_map = [
    'Airbag' => 'airbag',
    'Allianz' => 'allianz',
    'Ami3f' => 'ami3f',
    'Alptis' => 'alptis',
    'Apicil' => 'apicil',
    'Apivia' => 'apivia',
    'April' => 'april',
    'Assuréa' => 'assurea',
    'AssurMax' => 'assurmax',
    'Axa' => 'axa',
    'Dattak' => 'dattak',
    'Entoria' => 'entoria',
    'FMA' => 'fma',
    'Generali' => 'generali',
    'Helvetia' => 'helvetia',
    'Henner' => 'henner',
    'Harmonie Mutuelle' => 'harmonie',
    'Kereis' => 'kereis',
    'Groupe Leader' => 'groupe-leader',
    'Malakoff Humanis' => 'malakoff',
    'Maxance' => 'maxance',
    'Néoliane' => 'neoliane',
    'Netvox' => 'netvox',
    'Solly Azar' => 'sollyazar',
    'Spring' => 'spring',
    'Stoïk' => 'stoik',
    'Tetris' => 'tetris',
];

$source_id = function_exists('arc_get_administration_page_id') ? arc_get_administration_page_id() : 0;

if (!$source_id || !function_exists('get_field')) {
    $footer_html = '';
} else {

    $footer_html  = '<div class="divFooter">';
    $footer_html .= get_field('nom_du_cabinet', $source_id) . '<br>';
    $footer_html .= 'Siège social: ' . get_field('siege_social', $source_id)
        . ' - ' . get_field('forme_juridique', $source_id)
        . ' au capital de ' . get_field('capital_social', $source_id)
        . ' - RCS ' . get_field('rcs', $source_id)
        . ' N°' . get_field('n_rcs', $source_id)
        . ' - SIRET: ' . get_field('n_siret', $source_id)
        . ' - Code APE: 6622Z<br>';

    $footer_html .= 'Société de courtage en assurance (COA) - Conformément au code des assurances L.512-6: R.512-14<br>';

    $footer_html .= 'Enregistrée à l’ORIAS sous le n°' . get_field('n_orias_du_cabinet', $source_id)
        . ' - www.orias.fr - TVA INTRACOMMUNAUTAIRE: ' . get_field('n_tva_intracommunautaire', $source_id)
        . ' - Le Cabinet ' . get_field('nom_du_cabinet', $source_id) . ' applique la mention RGPD<br>';

    $footer_html .= 'Téléphone: ' . get_field('n_telephone_du_cabinet', $source_id)
        . ' - Mail: ' . get_field('adresse_mail_du_cabinet', $source_id);

    $footer_html .= '</div>';
}

/**
 * Helper : champ ACF du dossier "Conformité" (post courant)
 */
function cpg_field($name, $post_id = null, $escape = true) {

    $post_id = $post_id ?: get_the_ID();

    // Récupération ACF normale ou meta classique
    $val = function_exists('get_field') 
        ? get_field($name, $post_id)
        : get_post_meta($post_id, $name, true);

    // Si vide → retour vide
    if ($val === null || $val === false || $val === '') {
        return '';
    }

    // Si tableau → formatage propre
    if (is_array($val)) {

        // Cas checkbox ACF → tableau simple
        if (!empty($val) && !is_array(reset($val))) {
            $val = implode(', ', $val);
        }

        // Cas repeater ou tableau profond
        else {
            $formatted = [];
            foreach ($val as $row) {
                if (is_array($row)) {
                    $formatted[] = implode(' - ', array_filter($row));
                } else {
                    $formatted[] = $row;
                }
            }
            $val = implode(', ', $formatted);
        }
    }

    // Échappement
    return $escape ? esc_html($val) : $val;
}

// ---------- Helpers (safe: évite redeclare) ----------
if (!function_exists('cpg_norm_checkbox')) {
    function cpg_norm_checkbox($v): array {
        if (empty($v)) return [];
        if (is_array($v)) return array_values(array_filter(array_map('trim', array_map('strval', $v))));
        $v = trim((string)$v);
        if ($v === '' || $v === '&nbsp;') return [];
        if (strpos($v, ',') !== false) return array_values(array_filter(array_map('trim', explode(',', $v))));
        return [$v];
    }
}

if (!function_exists('cpg_logo_if')) {
    function cpg_logo_if(int $attachment_id, string $width = '20%'): void {

        if ($attachment_id <= 0) return;

        // mPDF préfère les chemins locaux
        $file = get_attached_file($attachment_id);
        if ($file && file_exists($file)) {
            echo '<img style="width:' . esc_attr($width) . ';" src="' . esc_attr($file) . '">';
            return;
        }

        // fallback URL
        $url = wp_get_attachment_image_url($attachment_id, 'full');
        if ($url) {
            echo '<img style="width:' . esc_attr($width) . ';" src="' . esc_url($url) . '">';
        }
    }
}
error_log('arc_logo_id_abeille=' . (int) get_option('arc_logo_id_abeille', 0));

if (!function_exists('cpg_render_logos')) {
    function cpg_render_logos(array $selected_all, array $logos_map, string $width = '30%', int $limit = 15): void {

        $eligible = [];

        foreach ($logos_map as $choice_value => $slug) {
            if (!in_array((string)$choice_value, $selected_all, true)) {
                continue;
            }

            $att_id = (int) get_option('arc_logo_id_' . (string) $slug, 0);
            if ($att_id > 0) {
                $eligible[(string)$choice_value] = $att_id;
            }
        }

        if (!$eligible) return;

        $keys = array_keys($eligible);
        shuffle($keys);
        $keys = array_slice($keys, 0, max(0, (int)$limit));

        foreach ($keys as $choice_value) {
            cpg_logo_if((int)$eligible[$choice_value], $width);

        }
    }
}




$cie1 = cpg_norm_checkbox(function_exists('get_field') ? get_field('cie1', $source_id) : get_post_meta($source_id,'cie1',true));
$cie2 = cpg_norm_checkbox(function_exists('get_field') ? get_field('cie2', $source_id) : get_post_meta($source_id,'cie2',true));
$cie3 = cpg_norm_checkbox(function_exists('get_field') ? get_field('cie3', $source_id) : get_post_meta($source_id,'cie3',true));
$cie4 = cpg_norm_checkbox(function_exists('get_field') ? get_field('cie4', $source_id) : get_post_meta($source_id,'cie4',true));

$selected_all = array_values(array_unique(array_merge($cie1, $cie2, $cie3, $cie4)));






/**
 * Helper : email de l’utilisateur courant (équivalent {power:user-email})
 */
function cpg_user_email() {
    $user = wp_get_current_user();
    if ($user && $user->user_email) {
        return esc_html($user->user_email);
    }
    return '';
}

/**
 * Helper : vérifie si une valeur ACF (string ou array) contient au moins une des cibles
 */
function cpg_has_any($value, array $targets) {
    if (is_array($value)) {
        foreach ($value as $v) {
            if (in_array((string)$v, $targets, true)) {
                return true;
            }
        }
        return false;
    }
    return in_array((string)$value, $targets, true);
}

function ret_uc_row($label, $field, $horizon, $color, $risk){
    global $post_id;
    return "
    <tr>
        <td style='border:0.5px solid black;height:30px;'>$label</td>
        <td style='border:0.5px solid black;'><b>" . cpg_field($field, $post_id) . "</b></td>
        <td style='border:0.5px solid black;'><i>$horizon</i></td>
        <td style='border:0.5px solid black;background-color:$color;'>$risk</td>
    </tr>";
}



?>
<!DOCTYPE html>
<html>
<head>
    <link href="https://fonts.googleapis.com/css2?family=Bebas+Neue&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro" rel="stylesheet" type="text/css">
    <meta charset="utf-8">
    <title>Conformité – PDF</title>

    <!-- Police proche de la version précédente -->
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro" rel="stylesheet" type="text/css">

    <style>
        body {
            font-family: roboto, "Source Sans Pro", sans-serif;
            font-size: 12px;
            text-align: justify;
        }

        .divFooter {
            position: fixed;
            bottom: 0;
            font-size: 7px;
            text-align: center;
            margin-left: auto;
            margin-right: auto;
            width: 100%;
        }
        .row {
            display: flex;
            flex-wrap: wrap;
            padding: 0 4px;
            text-align:center;
            vertical-align:middle;
            }

/* Create four equal columns that sits next to each other */
        .column {
            flex: 25%;
            max-width: 25%;
            padding: 0 4px;
            }

        .column img {
            margin-top: 8px;
            vertical-align: middle;
            width: 25%;
            }

        table {
            border-collapse: collapse;
        }

        table td, table th {
            vertical-align: top;
        }
    </style>
</head>
<body>








<div id="logo" style="text-align:center;">
<?php

// logo_cabinet = champ ACF "Fichier"
$logo = function_exists('get_field') && $source_id
    ? get_field('logo_cabinet', $source_id)
    : null;

// Selon ACF : $logo peut être un ID, une URL, ou un array
$logo_url = '';

if (is_array($logo)) {
    // Return format = Array
    $logo_url = $logo['url'] ?? '';
} elseif (is_numeric($logo)) {
    // Return format = ID
    $logo_url = wp_get_attachment_url((int) $logo);
} elseif (is_string($logo)) {
    // Return format = URL
    $logo_url = $logo;
}

if ($logo_url) : ?>
    <img width="30%" src="<?= esc_url($logo_url); ?>">
<?php endif; ?>
</div>


<h2 style="font-family:'Citizen';font-weight:100;color:#565555;text-align:center;text-transform: uppercase;padding-top:-10px;font-weight:900;">
Document d'entrée en relation
</h2>
<p style="font-family:'Citizen';font-weight:100;color:#565555;text-align:center;text-transform: uppercase;font-size:11px;padding-top:-20px;">
INFORMATIONS ET CONSEILS PREALABLES A LA CONCLUSION DU CONTRAT D’ASSURANCE FOURNIS EN APPLICATION DU CODE DES ASSURANCES (ARTICLES L521-1 à L522-7)
</p>

<h3 style="font-family:'Citizen';font-weight:100;text-transform: uppercase;padding-top:10px;text-decoration: underline;">
Présentation du cabinet
</h3>

<p style="font-family:'Roboto';font-size:11px;text-align: justify;">
Le cabinet <?= get_field('nom_du_cabinet', $source_id); ?> (“Le Cabinet”) est une <?= get_field('forme_juridique', $source_id); ?> au capital de <?= get_field('capital_social', $source_id); ?>, immatriculée au RCS de <?= get_field('rcs', $source_id); ?>  sous le numéro <?= get_field('n_rcs', $source_id); ?>. Son siège social est situé au <?= get_field('siege_social', $source_id); ?>. NAF/APE: 6622 Z<br>
Le Cabinet bénéficie d’un grand savoir-faire dans le courtage, en assurance de personnes, dans le domaine de la protection sociale, ainsi que dans le conseil de produits d’investissement d’épargne et de retraite. L’ensemble des distributeurs du Cabinet entendent mettre au service de leurs clients leurs compétences. <br>
Le Cabinet est un réseau de mandataires et de salariés spécialisés dans le conseil auprès des particuliers et des chefs d’entreprise, tant sur leurs patrimoines privés que sur la transmission de leurs outils professionnels. Parmi les spécificités du Cabinet se trouvent également l’audit et le conseil en protection sociale et le conseil en stratégie retraite. Dans cette optique, votre conseiller est formé en permanence à l’ensemble des aspects de la création de la gestion de patrimoine.
</p>


<h3 style="font-family:'Citizen';font-weight:100;text-transform: uppercase;padding-top:10px;text-decoration: underline;">
Nos prestations
</h3>

<p style="font-family:'Roboto';font-size:11px;text-align: justify;">
Le Cabinet, après analyse des informations recueillies auprès de ses clients et de ses prospects, peut procéder à l’audit et le conseil en protection sociale, à l’audit et le conseil en stratégie retraite, à l’audit et le conseil en stratégie patrimonial, au conseil en produits d’épargne et produits retraite ainsi qu’à la gestion de budget.
</p>

<h3 style="font-family:'Citizen';font-weight:100;text-transform: uppercase;padding-top:10px;text-decoration: underline;">
STATUTS LEGAUX, AGRÉMENTS ET AUTORITÉS DE TUTELLE
</h3>

<p style="font-family:'Roboto';font-size:11px;text-align: justify;">
Votre conseiller est immatriculé au Registre Unique des intermédiaires en assurance, Banque et finance (ORIAS) sous le numéro <?= get_field('n_orias_du_cabinet', $source_id); ?>. Vous pouvez vérifier cette immatriculation, au titre des activités suivantes sur le site de l’ORIAS (<b>https://www.orias.fr</b>)<br><br>

COA (Courtier en assurances ou de réassurances): Le Cabinet exerce son activité de courtage d’assurance conformément à l’article L.521-2 (courtier catégorie B) du code des assurances. Catégorie contrôlée par l’Autorité de Contrôle Prudentiel et de Résolution, ACPR (4 place de Budapest - 75436 Paris cedex 09, <b>https://acpr.banque-france.fr/</b>).<br><br>

Votre conseiller dispose, conformément à la loi et au code des assurances, d’une couverture en Responsabilité Civile Professionnelle, souscrite auprès de:<br><br>

<?= get_field('compagnie_rc_professionnelle', $source_id); ?><br>
<?= get_field('siege_social_rcpro', $source_id); ?><br>
N° Contrat: <?= get_field('n_contrat', $source_id); ?>

</p>


<h3 style="font-family:'Citizen';font-weight:100;text-transform: uppercase;padding-top:10px;text-decoration: underline;">
MODE DE COMMUNICATION
</h3>

<p style="font-family:'Roboto';font-size:11px;text-align: justify;">
La communication entre le Cabinet et le prospect pourra avoir lieu selon les modalités suivantes (liste non exhaustive):<br><br>

• Conversations téléphoniques au <?= get_field('n_telephone_du_cabinet', $source_id); ?><br>
• Mail sur la boite: <b><?= get_field('adresse_mail_du_cabinet', $source_id); ?></b><br>
• Rendez-vous physique chez le prospect (domicile et lieu de travail)<br>
• Rendez-vous téléphoniques / visioconférence<br><br>

Conformément aux dispositions de code des assurances, vous pourrez obtenir avec le concours du cabinet qui s’engage à vous assister dans leur obtention, la communication d’informations plus précises auprès d’établissements bancaires, fournisseurs et Compagnies d’assurances.

</p>
<p style="page-break-before:always;"></p>

<h3 style="font-family:'Citizen';font-weight:100;text-transform: uppercase;padding-top:10px;text-decoration: underline;">
PARTENAIRES DU CABINET
</h3>

<div class="row">
<div class="column">

<?php cpg_render_logos($selected_all, $logos_map, '20%'); ?>


</div>

</div>
<i>*Liste non exhaustive</i>
<h3 style="font-family:'Citizen';font-weight:100;text-transform: uppercase;text-decoration: underline;">
MODE DE FACTURATION ET RÉMUNÉRATION DU CABINET
</h3>

<p style="font-family:'Roboto';font-size:11px;text-align: justify;">
Nous tenons à vous informer que cette proposition de mission ne générera aucun frais ou honoraire supplémentaire. Notre rémunération se compose de commissions versées par les compagnies que nous choisissons de vous
proposer. Le montant de nos commissions peut varier. L’atteinte de paliers de chiffre d’affaires ou de volume d’affaires traités sur certains contrats peut générer le versement de commissions supplémentaires (surcommissions) par nos partenaires. Nous vous garantissons toutefois d’agir dans le strict respect de vos intérêts particuliers. Nos recommandations sont systématiquement soumises à la validation de l’adéquation de nos préconisations en fonction de vos besoins et exigences exprimés et analysés.<br><br>
Ainsi, nous pourrons recevoir le cas échéant :<br>
• Commissions de courtage<br>
• Commissions supplémentaires assujetties à l’atteinte d’un volume d’affaires<br><br>
Le détail de la rémunération du cabinet agissant en tant qu'intermédiaire, peut être obtenu par le client sur simple
demande écrite. Le conseiller s'engage à assister le client dans l'obtention de ces informations.

</p>


<p style="page-break-before:always;"></p>

<!-- - - - - - - - - - - - - - - - - -->


<!-- - - - - - - - - - - - - - - - - PAGE ACCUEIL -->
<h2 style="font-family:'Citizen';font-weight:100;color:#565555;text-align:center;text-transform: uppercase;padding-top:-10px;font-weight:900;">
Recueil d'exigences & besoins
</h2>


<h3 style="font-family:'Citizen';font-weight:100;text-transform: uppercase;padding-top:10px;text-decoration: underline;">
DEMANDES ET EXIGENCES DU PROSPECT
</h3><br>
<div style="border-width:1px;border-style:solid;border-color:black;width:100%;height:fit-content;margin-right:5%;margin-left:5%;padding:5%;">
<p style="font-family:'Roboto';font-size:11px;text-align: justify;">  <?= cpg_field('exigences', $post_id) ?>  </p>
</div>
<br>

<h3 style="font-family:'Citizen';font-weight:100;text-transform: uppercase;padding-top:10px;text-decoration: underline;">
INFORMATIONS PRINCIPALES
</h3>

<p style="font-family:'Roboto';font-size:11px;text-align: justify;">
Nom: <i> <?= cpg_field('nom_client', $post_id) ?></i><br><br>
Prénom: <i> <?= cpg_field('prenom_client', $post_id) ?></i><br><br>
Email: <i> <?= cpg_field('mail', $post_id) ?></i><br><br>
Téléphone: <i> <?= cpg_field('tel', $post_id) ?></i><br><br>
Adresse: <i> <?= cpg_field('adresse', $post_id) ?></i><br><br>
Ville: <i> <?= cpg_field('ville', $post_id) ?></i><br><br>
Code postal: <i> <?= cpg_field('cp', $post_id) ?></i><br><br>
</p>








<p style="page-break-before:always;"></p>

<h3 style="font-family:'Citizen';font-weight:100;text-transform: uppercase;padding-top:10px;text-decoration: underline;">
TRAITEMENT DES RÉCLAMATIONS
</h3>

<p style="font-family:'Roboto';font-size:11px;text-align: justify;">
Pour toute réclamation, votre conseiller peut être contacté selon les modalités suivantes:<br><br>

Par courrier: <?= get_field('forme_juridique', $source_id); ?> <?= get_field('nom_du_cabinet', $source_id); ?>, <?= get_field('siege_social', $source_id); ?><br>
Par mail: <b><?= get_field('adresse_mail_du_cabinet', $source_id); ?></b><br><br>

Votre conseiller et le Cabinet s’engagent à traiter votre réclamation dans les délais suivants:<br><br>

• Dix jours ouvrables maximum à compter de la réception de la réclamation, pour accuser réception, sauf si la réponse elle-même est apportée au client dans ce délai;<br>
• Deux mois maximums entre la date de réception de la réclamation et la date d’envoi de la réponse au client sauf survenance de circonstances particulières dûment justifiées.

</p>

<h3 style="font-family:'Citizen';font-weight:100;text-transform: uppercase;padding-top:10px;text-decoration: underline;">
SAISIR UN MÉDIATEUR
</h3>

<p style="font-family:'Roboto';font-size:11px;text-align: justify;">
Pour les activités d’assurance:<br><br>

La médiation de l’assurances, TSA 50110 75441 Paris cedex 09<br><br>

Site internet: <b>https://www.mediation-assurance.org/</b>

</p>

<h3 style="font-family:'Citizen';font-weight:100;text-transform: uppercase;padding-top:10px;text-decoration: underline;">
RÈGLEMENT GÉNÉRAL SUR LA PROTECTION DES DONNÉES (RGPD)
</h3>

<p style="font-family:'Roboto';font-size:11px;text-align: justify;">
Retrouvez les informations nécessaires sur notre site internet (<b><?= get_field('lien_vers_la_politique_de_confidentialite', $source_id); ?></b>) concernant la protection des données.

</p>



<h3 style="font-family:'Citizen';font-weight:100;text-transform: uppercase;padding-top:10px;text-decoration: underline;">
NOTE IMPORTANTE
</h3>
  <p style="font-family:'Roboto';font-size:11px;text-align: justify;"><i>Les modalités d'application du contrat et garanties sont détaillées dans la notice d'information correspondante. La notice d'information précise notamment les montants et limites de garanties ainsi que les exclusions.</i></p>

<h3 style="font-family:'Citizen';font-weight:100;text-transform: uppercase;padding-top:10px;text-decoration: underline;">
SIGNATURES
</h3>

<p style="font-family:'Roboto';font-size:11px;text-align: justify;"><i>Le signataire déclare que les déclarations ou réponses qui ont servies de base à l'établissement du présent document sont sincères et exactes et reconnait avoir pris connaissance du présent document avant la conclusion du contrat d'assurance.</i>
<br>  <br>  <br>
Le <?= cpg_field('date_du_jour', $post_id) ?>,</p>  <br>
<div style="width:40%;float:left;margin-left:5%;">
<h5 style="font-family:'Roboto';text-transform: uppercase;font-size:10px;vertical-align:top;">
LE PROSPECT<br>
</h5>
</div>

<div style="width:40%;float:right;margin-right:5%;">
<h5 style="font-family:'Roboto';text-transform: uppercase;font-size:10px;vertical-align:top;">
CABINET <?= get_field('nom_du_cabinet', $source_id); ?><br>
</h5>
</div>

<div style="border-width:1px;border-style:solid;border-color:black;width:40%;height:100px;float:left;margin-left:5%;">

</div>

<div style="border-width:1px;border-style:solid;border-color:black;width:40%;height:100px;float:right;margin-right:5%;">

</div>














</body>
</html>
