<?php
/*
Plugin Name: CPT - Nouvelle vente
Description: Ajoute un type de contenu personnalisé pour les nouvelles ventes.
Version: 1.0
Author: Kyllian GALLAY
*/

function creer_cpt_nouvelle_vente() {
    $labels = array(
        'name' => 'Nouvelles ventes',
        'singular_name' => 'Nouvelle vente',
        'menu_name' => 'Nouvelle vente',
    );
    
    $args = array(
        'labels' => $labels,
        'public' => true,
        'has_archive' => true,
        'rewrite' => array('slug' => 'nouvelle_vente'),
        'menu_icon' => 'dashicons-portfolio',
        'supports' => array('title', 'editor', 'thumbnail'),
        'show_in_rest' => true,
        'taxonomies' => array('post_tag', 'category'),
    );
    
    register_post_type('nouvelle_vente', $args);
}
add_action('init', 'creer_cpt_nouvelle_vente');