<?php

namespace VendorDuplicator\Psr\Http\Client;

use VendorDuplicator\Psr\Http\Message\RequestInterface;
use VendorDuplicator\Psr\Http\Message\ResponseInterface;
interface ClientInterface
{
    /**
     * Sends a PSR-7 request and returns a PSR-7 response.
     *
     * @param RequestInterface $request
     *
     * @return ResponseInterface
     *
     * @throws \VendorDuplicator\Psr\Http\Client\ClientExceptionInterface If an error happens while processing the request.
     */
    public function sendRequest(RequestInterface $request): ResponseInterface;
}
