<?php

// SPDX-FileCopyrightText: 2022-2025 Ovation S.r.l. <help@dynamic.ooo>
// SPDX-License-Identifier: LicenseRef-GPL-3.0-with-dynamicooo-additional-terms
namespace DynamicShortcodes\Core\Settings\AdminPages;

/**
 * Admin Pages Utilities
 *
 * Provides utility functions for admin pages.
 */
class Utilities {
	/**
	 * Maps plugin ID to plugin name
	 *
	 * @param string $plugin_id The plugin ID to map
	 * @return string The plugin name
	 */
	public static function get_plugin_name( $plugin_id ) {
		$plugin_names = [
			'dce' => 'Dynamic Content for Elementor',
			'dtb' => 'Dynamic Toolbox for Bricks',
		];

		return isset( $plugin_names[ $plugin_id ] ) ? $plugin_names[ $plugin_id ] : $plugin_id;
	}
}
