<?php 

defined( 'ABSPATH' ) || exit;

class Woffice_Extension_Cover_Image {

	public function __constructor() {
		$enable_woffice_cover_image_extenstion = get_option('woffice_theme_options');

		if ( !isset($enable_woffice_cover_image_extenstion['enable_woffice_cover_image_extenstion']) || isset($enable_woffice_cover_image_extenstion['enable_woffice_cover_image_extenstion']) && !$enable_woffice_cover_image_extenstion['enable_woffice_cover_image_extenstion'] ) {
			return;
		}

		$this->_init();
	}


	/**
	 * @internal
	 */
	public function _init() {
		add_filter( 'bp_is_profile_cover_image_active', '__return_false' );
	}

	/**
	 * We check if the user has a cover image, if yes we return the URL of the image
	 *
	 * @param int $user_ID
	 *
	 * @return bool
	 */
	public static function woffice_cover_member_state($user_ID) {

		return (bool)woffice_get_cover_image( $user_ID );
	}
	
}

new Woffice_Extension_Cover_Image();