<?php 

defined( 'ABSPATH' ) || exit;

/**
 * Function to quickly checks that the extension is enabled
 *
 * @return void
 */
function woffice_directory_extension_on(){

	
	$enable_directory_extenstion = get_option('woffice_theme_options');

	if ( isset($enable_directory_extenstion['enable_directory_extenstion']) && !$enable_directory_extenstion['enable_directory_extenstion'] ) {
		return false;
	} else {
		return true;
	}
}

/**
 * Custom Excerpt function
 *
 * @return string
 */
function woffice_directory_get_excerpt() {
	$limit = 20;

	// If we have a content set: we display content
    // Otherwise, fall back to excerpt (we need to keep that as a lot of users use excerpts
    if (get_the_content() !== '') {
        $excerpt = explode(' ', get_the_content(), $limit);
    } else {
        $excerpt = explode(' ', get_the_excerpt(), $limit);
    }

	if (count($excerpt)>=$limit) {
	    array_pop($excerpt);
	    $excerpt = implode(" ",$excerpt).'...';
	} else {
	    $excerpt = implode(" ",$excerpt);
	}	

	$excerpt = preg_replace('`\[[^\]]*\]`','',$excerpt);
	
	return $excerpt;
}
/**
 * Map on the single page
 */
function woffice_directory_single_map(){
	$item_location = get_post_meta( get_the_ID(), 'directory_item_location',true);

	if (!$item_location) {
		return;
	}

	if (!empty($item_location['latitude']) && !empty($item_location['longitude'])) {
		
		echo '<div id="map-directory-single"></div>';

		$label = '';

		if (!empty($item_location['locality'])) {
			$label = $item_location['locality'] .', '. $item_location['locality'];
		} elseif (!empty($item_location['latitude'])) {
			$label = $item_location['latitude'] .', '. $item_location['longitude'];
		}

		echo '<span class="bottom-map-location"><i class="fa fa-map-marker text-light"></i>'. $label .'</span>';
	}
}

/**
 * Return the HTML printed by the function woffice_directory_single_map()
 *
 * @return string
 */
function woffice_get_directory_single_map(){
	ob_start();
	woffice_directory_single_map();
	return ob_get_clean();
}

/**
 * Get a the custom fields
 *
 * @param string $type
 */
function woffice_directory_single_fields($type){
	$class = ($type == "single") ? "on-single" : "intern-box";
	
	// IF NO DEFAULT FIELDS 
	$default_fields = woffice_get_theming_option('directory_default_fields');
	$item_fields = ( function_exists( 'get_post_meta' ) ) ? get_post_meta(get_the_ID(), 'directory_items_fields',true) : '';

	if (isset($item_fields['title']) && !empty($item_fields['title'])) {
		
		if (isset($item_fields['title']) && !empty($item_fields['title'])) {
			echo '<div class="directory-item-fields">';
				echo '<ul>';
				foreach ($item_fields['title'] as $key => $field) {
					echo '<li class="directory-item-field">';
						echo (!empty($item_fields['icon'][$key])) ? '<i class="'. $item_fields['icon'][$key] .'"></i>' : '';
						echo (!empty($item_fields['title'][$key])) ? $item_fields['title'][$key] : '';
					echo '</li>';
				} 
				echo '</ul>';
			echo '</div>';
		}
		
	} else {
		
		// IF DEFAULT FIELDS
		echo '<div class="directory-item-fields '.$class.'">';
			echo '<ul>';
				
				if (isset($default_fields['custom_field_title']) && !empty($default_fields['custom_field_title'])) {
					foreach ($item_fields['custom_field_title'] as $key => $field) {
						echo '<li class="directory-item-field">';
							echo (!empty($item_fields['custom_field_icon'][$key])) ? '<i class="'. $item_fields['custom_field_icon'][$key] .'"></i>' : '';
							echo (!empty($item_fields['custom_field_title'][$key])) ? $item_fields['custom_field_title'][$key] : '';
						echo '</li>';
					}
				}
			echo '</ul>';
		echo '</div>';
	}
}

/**
 * Return the HTML printedn by the function woffice_directory_single_fields()
 *
 * @param $type
 *
 * @return string
 */
function woffice_get_directory_single_fields( $type ) {
	ob_start();
	woffice_directory_single_fields( $type );
	return ob_get_clean();
}

if(!function_exists('woffice_directory_content_exists')) {
	/**
	 * Check if the current directory has some content to render in the header (It works in the loop)
	 *
	 * @return bool
	 */
	function woffice_directory_content_exists()
	{
		$directory_filter = woffice_get_theming_option('directory_filter', false);

		return $directory_filter;
	}
}

if(!function_exists('woffice_update_directory_meta')) {
	function woffice_update_directory_meta($post_id,$meta_key,$value) {

		if($meta_key == 'directory_items_fields') {
			if(!empty($value)){
				$new_field = array();
				foreach($value as $key => $field_value) {
					$new_field['redux_repeater_data'][]['title'] = '';
					$new_field['title'][] = $field_value['title'];
					$new_field['icon'][] = $field_value['icon'];
				}
				if(!empty($new_field)) {
					update_post_meta($post_id,$meta_key, $new_field);
				}
			}
		} else {
			update_post_meta($post_id,$meta_key,$value);
		}
	}
}

function woffice_directory_single_edit_fields($fields){
	$new_field = array();
	if(!empty($fields)) {
		$counter = 0;
		foreach($fields as $key => $field_value) {
			$new_field[] = array(
				'title' => $fields['title'][$counter],
				'icon' => $fields['icon'][$counter]
			);
			$counter ++;
		}
	}
	return $new_field;
}


if(!function_exists('woffice_migrate_woffice_directory_meta')) {

    function woffice_migrate_woffice_directory_meta() {

        $enable_directory_extenstion = get_option('woffice_theme_options');
        $woffice_directory_migrated = get_option('woffice_directory_migrated');

        if ( !isset($enable_directory_extenstion['enable_directory_extenstion']) || isset($enable_directory_extenstion['enable_directory_extenstion']) && !$enable_directory_extenstion['enable_directory_extenstion']  || $woffice_directory_migrated) {
            return;
        } else {
            if(is_admin() && current_user_can('edit_posts') ) {
                $args = array(
                    'post_type' => 'directory',
                    'posts_per_page' => '-1'
                );
    
                $woffice_directory_lists = new WP_Query($args);
                
                if(!empty($woffice_directory_lists) && $woffice_directory_lists->found_posts > 0) {
                    $count = 0;
                    foreach($woffice_directory_lists->posts as $directory) {
                       $metas = get_post_meta($directory->ID,'fw_options',true);
                        if (isset($metas['item_fields']) && !empty($metas['item_fields'])) {
                              $directory_meta_item = array();
                           
                              foreach ($metas['item_fields'] as $key => $value) {
                                $directory_meta_item['redux_repeater_data'][]['title'] = '';
                                $directory_meta_item['title'][] = $value['title'];
                                $directory_meta_item['icon'][] = $value['icon'];
                              }

                            if(!empty($directory_meta_item)) {
                                update_post_meta($directory->ID,'directory_items_fields', $directory_meta_item);
                            }
                        }
                       $count ++;
                    }
                   if($count == $woffice_directory_lists->found_posts) {
                        update_option('woffice_directory_migrated',true);
                   }
                }
            }
        }
    }

    add_action('admin_init','woffice_migrate_woffice_directory_meta');
}