<?php

defined( 'ABSPATH' ) || exit;

if(!function_exists('woffice_is_user_visible_event')) {
    /**
     * Check if current user has access into the event
     *
     * @param string $visibility
     *
     * @return mixed
     */
    function woffice_is_user_visible_event($visibility) {
        $arr_visibility = explode('_', $visibility);
        $post_id = isset($arr_visibility[1]) ? $arr_visibility[1] : get_the_ID();
        
        return Woffice_Extension_Woffice_Event::user_authorize($post_id, $arr_visibility[0]);
    }
    
}

if(!function_exists('woffice_migrate_redux_meta')) {

    function woffice_migrate_event_meta() {

        $enable_event_extenstion = get_option('woffice_theme_options');
        $woffice_event_migrated = get_option('woffice_event_migrated');

		if ( isset($enable_event_extenstion['enable_woffice_event_extenstion']) && !$enable_event_extenstion['enable_woffice_event_extenstion']  || $woffice_event_migrated) {
			return;
		} else {
            if(is_admin() && current_user_can('edit_posts') ) {
                $args = array(
                    'post_type' => 'woffice-event',
                    'posts_per_page' => '-1'
                );
    
                $woffice_event_lists = new WP_Query($args);
                
                if(!empty($woffice_event_lists) && $woffice_event_lists->found_posts > 0) {
                    $count = 0;
                    foreach($woffice_event_lists->posts as $event) {
                       $metas = get_post_custom($event->ID);
                       foreach($metas as $key => $meta) {
                            if (strpos($key,'fw_option:woffice_') !== false) {
                               $updated_key = str_replace('fw_option:','',$key);
                               update_post_meta($event->ID,$updated_key,$meta[0]);
                            }
                       }
                       $count ++;
                    }
                   if($count == $woffice_event_lists->found_posts) {
                        update_option('woffice_event_migrated',true);
                   }
                }
            }
        }
    }

    add_action('admin_init','woffice_migrate_event_meta');
}
