<?php 

defined( 'ABSPATH' ) || exit;

class Woffice_Extension_Maintenance {

	/**
	 * @internal
	 */

	 public function __construct() {
		$this->_init();
	}

	/**
	 * @internal
	 */
	public function _init() {

		$enabe_woffice_maintenance = get_option('woffice_theme_options');

		if ( !isset($enabe_woffice_maintenance['enabe_woffice_maintenance']) || isset($enabe_woffice_maintenance['enabe_woffice_maintenance']) && !$enabe_woffice_maintenance['enabe_woffice_maintenance'] ) {
			return;
		}

		add_action('admin_init', array($this, 'woffice_maintenance_create_page'));
		add_action('admin_init', array($this, 'woffice_maintenance_delete_page'));

	}

	/**
	 * We create the Maintenance page on the extension activation
	 */
	public function woffice_maintenance_create_page($extensions)
	{

		/* ONLY IF IT's the Maintenance extension */
		$enabe_woffice_maintenance = get_option('woffice_theme_options');

		if ( isset($enabe_woffice_maintenance['enabe_woffice_maintenance']) && $enabe_woffice_maintenance['enabe_woffice_maintenance'] ) {
			// Check that the page exists - or create it
			woffice_maintenance_create_check_page();
		}
	}

	/**
	 * We delete the page if the extension is not activated
	 */
	public function woffice_maintenance_delete_page($extensions) {

	    /* ONLY IF IT's the Maintenance extension */
		$enabe_woffice_maintenance = get_option('woffice_theme_options');

		if ( isset($enabe_woffice_maintenance['enabe_woffice_maintenance']) && !$enabe_woffice_maintenance['enabe_woffice_maintenance'] ) {
			return;
		}

		/* We find the maintenance page ID */
		$page = function_exists('woffice_get_page_by_title') ? woffice_get_page_by_title( 'Maintenance' ) : get_page_by_title( 'Maintenance' );
		
		/* We delete it */
		if (!empty($page)) {
			$ID_page = $page->ID;
			wp_delete_post($ID_page);
		}

	}
}

new Woffice_Extension_Maintenance();
