<?php 
defined( 'ABSPATH' ) || exit;
	
/**
 * Generate the js for the map
 *
 * @return void
 */		
function woffice_members_map_js_users(){
	if (function_exists('bp_is_active') && bp_is_members_directory()) {
        echo Woffice_Extension_Map::usersMapJs("members");
    }
}
add_action('wp_footer', 'woffice_members_map_js_users');

/**
 * Renders the map in the directory
 */
function woffice_members_output_map() {
	echo woffice_render_widget_view(WOFFICE_CORE_PATH. '/extensions/woffice-map/views/view.php');
}
add_action('bp_before_directory_members_page', 'woffice_members_output_map');

/**
 * Create the field to prompt the user location
 *
 * @return void
 */
function woffice_location_add_field() {

    if (!function_exists('woffice_get_xprofile_table') && !woffice_bp_is_active('xprofile') || !current_user_can('manage_options'))
        return;

    if(!function_exists('buddypress')){
        return;
    }

    global $wpdb;
        
    $bp = buddypress();
    $field_name = class_exists('Woffice_Extension_Map') ? Woffice_Extension_Map::mapFieldName() : __('Location','woffice');
    $field_exist = $wpdb->get_row($wpdb->prepare("SELECT id FROM {$bp->profile->table_name_fields} WHERE name = %s", $field_name));
    $field = woffice_get_the_location_field();

    if(is_array($field) && count($field) > 0) {
        //in order to remove the old textarea on some Woffice websites
        if ($field[0]->type === "textarea") {
            global $wpdb;
            $wpdb->update(
                $bp->profile->table_name_fields,
                array(
                    'type' => 'textbox'
                ),
                array( 'id' => $field[0]->id ),
                array(
                    '%s',	// string
                ),
                array( '%d' )
            );
        }
        return;
    }

    if(!$field_exist && function_exists('xprofile_insert_field')){
        xprofile_insert_field(
            array (
                'field_group_id'  => 1,
                'can_delete' => true,
                'type' => 'textbox',
                'description' => __('This address will be used on the members directory map, please make sure this address is valid for Google Map.','woffice'),
                'name' => class_exists('Woffice_Extension_Map') ? Woffice_Extension_Map::mapFieldName() : '',
                'field_order'     => 1,
                'is_required'     => false,
            )
        );
    }
}
add_action('bp_init', 'woffice_location_add_field');

/**
 * We send the data to our scripts.js file
 *
 * @param array $data - the current data sent to the file
 *
 * @return array
 */
if(!function_exists('woffice_location_data_exchanger')) {
    function woffice_location_data_exchanger($data) {

        $field = woffice_get_the_location_field();

        if(is_null($field) || empty($field) )
            return $data;

        $data['input_location_bb'] = 'field_' . $field[0]->id;

        return $data;

    }
}
add_filter('woffice_js_exchanged_data', 'woffice_location_data_exchanger');

/**
 * Refresh all map coordinates for all members
 *
 * @return void
 */
function woffice_map_refresh_all_coordinates() {

    if (!isset($_GET["refresh_all_coordinates"]))
        return;

    if ($_GET["refresh_all_coordinates"] === "true") {
        
        Woffice_Extension_Map::saveAllMembers();
        wp_redirect(admin_url('admin.php?page=woffice_theme_options&extension=woffice-map&refresh_all_coordinates=done'));
        exit();
    }
    else if ($_GET["refresh_all_coordinates"] === "done") {
        /**
         * Triggers a notice in the backend in order to let the user know that the operation succeeded
         */
        function woffice_map_refresh_admin_notice_success() {
            ?>
            <div class="notice notice-success is-dismissible">
                <p><?php _e( 'Done!', 'woffice' ); ?></p>
            </div>
            <?php
        }
        add_action( 'admin_notices', 'woffice_map_refresh_admin_notice_success' );
    }

}
add_action('admin_init', 'woffice_map_refresh_all_coordinates');
