<?php if ( ! defined( 'ABSPATH' ) ) { die( 'Direct access forbidden.' ); }

class Widget_Woffice_Projects extends WP_Widget {

	/**
	 * @internal
	 */
	function __construct() {
		$enable_woffice_project_extenstion = get_option('woffice_theme_options');
		if ( !isset($enable_woffice_project_extenstion['enable_woffice_project_extenstion']) || isset($enable_woffice_project_extenstion['enable_woffice_project_extenstion']) && !$enable_woffice_project_extenstion['enable_woffice_project_extenstion'] ) {
			return;
		}
		
		$widget_ops = array( 'description' => 'Woffice widget to display the user projects.' );
		parent::__construct( false, __( '(Woffice) Projects', 'woffice' ), $widget_ops );
	}
	/**
	 * @param array $args
	 * @param array $instance
	 */
	function widget( $args, $instance ) {


        $data = array(
            'before_widget' => $args['before_widget'],
            'after_widget'  => $args['after_widget'],
            'before_title'  => str_replace( 'class="', 'class="widget_projects ', $args['before_title']),
            'after_title'   => $args['after_title'],
            'title'         => str_replace( 'class="', 'class="widget_projects ',
                    $args['before_title'] ) . esc_html($instance['title']) . $args['after_title'],
            //'category' 	    => $instance['category']
            'current_user' 	    => ( array_key_exists('current_user', $instance)) ? $instance['current_user'] : false
        );

        if (array_key_exists('category', $instance)) {
	        $data['category'] = $instance['category'];
        }

		if (array_key_exists('status', $instance)) {
			$data['status'] = $instance['status'];
		}

		echo woffice_render_widget_view(WOFFICE_CORE_PATH. '/extensions/woffice-projects/views/widget.php', $data);
		
	}

	function update( $new_instance, $old_instance ) {
		return $new_instance;
	}

	function form( $instance ) {
		$instance = wp_parse_args( (array) $instance, array( 'title' => '', 'category' => 'all', 'current_user' => 0 ));

		?>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php _e( 'Title', 'woffice' ); ?> </label>
			<input type="text" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>"
			       value="<?php echo esc_attr( $instance['title'] ); ?>" class="widefat"
			       id="<?php esc_attr( $this->get_field_id( 'title' ) ); ?>"/>
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'current_user' ) ); ?>">
				<input type="checkbox" name="<?php echo esc_attr( $this->get_field_name( 'current_user' ) ); ?>"
				       id="<?php echo esc_attr( $this->get_field_id( 'current_user' ) ); ?>"
				       value="1"
					<?php checked($instance['current_user'])?>
				/>
				<?php _e( 'Only current user', 'woffice' ); ?>
			</label>
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id('category') ); ?>"><?php _e('Category:','woffice'); ?></label>
			<?php
			// GET PROJECTS CATEGORY
			$projects_terms = get_terms('project-category', array('hide_empty' => false)); ?>
			<select class="widefat" name="<?php echo esc_attr( $this->get_field_name('category') ); ?>" id="<?php echo esc_attr( $this->get_field_id('category') ); ?>">
				<option value="all"><?php _e('All','woffice'); ?></option>
				<?php if ($projects_terms) :
					foreach ( $projects_terms as $term ) { ?>
			            <option value="<?php echo esc_attr( $term->slug ); ?>" <?php selected($term->slug, (isset($instance['category']) ? $instance['category'] : null)); ?>><?php echo esc_html( $term->name ); ?></option>
			        <?php }
				endif; ?>
			</select>
		</p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id('status') ); ?>"><?php _e('Status:','woffice'); ?></label>
            <select class="widefat" name="<?php echo esc_attr( $this->get_field_name('status') ); ?>" id="<?php echo esc_attr( $this->get_field_id('status') ); ?>">
                <option value="all" <?php selected('all', (isset($instance['status']) ? $instance['status'] : null)); ?>><?php _e('All','woffice'); ?></option>
				<option value="archived" <?php selected('archived', (isset($instance['status']) ? $instance['status'] : null)); ?>><?php _e('Archived', 'woffice'); ?></option>
				<option value="done" <?php selected('done', (isset($instance['status']) ? $instance['status'] : null)); ?>><?php _e('Done', 'done'); ?></option>
				<option value="in_progress" <?php selected('in_progress', (isset($instance['status']) ? $instance['status'] : null)); ?>><?php _e('In progress', 'woffice'); ?></option>
				<option value="in_review" <?php selected('in_review', (isset($instance['status']) ? $instance['status'] : null)); ?>><?php _e('In review', 'woffice'); ?></option>
				<option value="planned" <?php selected('planned', (isset($instance['status']) ? $instance['status'] : null)); ?>><?php _e('planned', 'woffice'); ?></option>
            </select>
        </p>
	<?php
	}
}

function fw_ext_woffice_projects_register_widget() {
		$enable_woffice_project_extenstion = get_option('woffice_theme_options');
		
		if ( !isset($enable_woffice_project_extenstion['enable_woffice_project_extenstion']) || isset($enable_woffice_project_extenstion['enable_woffice_project_extenstion']) && !$enable_woffice_project_extenstion['enable_woffice_project_extenstion'] ) {
			return;
		} else {
			register_widget( 'Widget_Woffice_Projects' );
		}
}
add_action( 'widgets_init', 'fw_ext_woffice_projects_register_widget' );

