<?php 

class Widget_Woffice_Recent_Posts extends WP_Widget {

	/**
	 * @internal
	 */
	function __construct() {

		$enable_woffice_recentpost_extenstion = get_option('woffice_theme_options');

		if (!isset($enable_woffice_recentpost_extenstion['enable_woffice_recentpost_extenstion']) || isset($enable_woffice_recentpost_extenstion['enable_woffice_recentpost_extenstion']) && !$enable_woffice_recentpost_extenstion['enable_woffice_recentpost_extenstion'] ) {
			return;
		}
		
		$widget_ops = array( 'description' => 'Woffice widget to display the Recent posts.' );
		parent::__construct( false, __( '(Woffice) Recents posts', 'woffice' ), $widget_ops );
	}
	/**
	 * @param array $args
	 * @param array $instance
	 */
	function widget( $args, $instance ) {
	
	
		$data = array(
			'before_widget' => $args['before_widget'],
			'after_widget'  => $args['after_widget'],
			'title'  		=> isset($instance['title']) ? $instance['title'] :  __( 'Recent Posts', 'woffice'),
			'number_of_item'  => isset($instance['number_of_item']) ? $instance['number_of_item'] : 5,
			'before_title'  => str_replace( 'class="', 'class="widget_woffice_recent_posts ', $args['before_title']),
			'after_title'   => $args['after_title'],
		);

			echo woffice_render_widget_view(WOFFICE_CORE_PATH. '/extensions/woffice-recent-posts/views/widget.php', $data );
		
	}

	function form( $instance ) {
		$instance = wp_parse_args( (array) $instance, array( 'title' => __( 'Recent Posts', 'woffice'), 'category' => 'all', 'current_user' => 0 ));
		$instance = wp_parse_args( (array) $instance, array( 'number_of_item' => 5));

		?>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php _e( 'Title', 'woffice' ); ?> </label>
			<input type="text" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>"
				value="<?php echo esc_attr( $instance['title'] ); ?>" class="widefat"
				id="<?php esc_attr( $this->get_field_id( 'title' ) ); ?>"/>
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'number_of_item' ) ); ?>"><?php _e( 'Number of posts', 'woffice' ); ?> </label>
			<input type="number" name="<?php echo esc_attr( $this->get_field_name( 'number_of_item' ) ); ?>"
				value="<?php echo esc_attr( $instance['number_of_item'] ); ?>" class="widefat"
				id="<?php esc_attr( $this->get_field_id( 'number_of_item' ) ); ?>"/>
		</p>
	<?php
	}

	function update( $new_instance, $old_instance ) {
		return $new_instance;
	}
}

function fw_ext_woffice_recent_posts_register_widget() {
	$enable_woffice_recentpost_extenstion = get_option('woffice_theme_options');

	if (!isset($enable_woffice_recentpost_extenstion['enable_woffice_recentpost_extenstion']) || isset($enable_woffice_recentpost_extenstion['enable_woffice_recentpost_extenstion']) && !$enable_woffice_recentpost_extenstion['enable_woffice_recentpost_extenstion'] ) {
		return;
	} else {
		register_widget( 'Widget_Woffice_Recent_Posts' );
	}	
}
add_action( 'widgets_init', 'fw_ext_woffice_recent_posts_register_widget' );

