<?php

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Redux' ) ) {
	return;
}

/*We search for the login page*/


$login_page_default = woffice_get_settings_option('login_page');
$login_page = function_exists('woffice_get_page_by_title') ? woffice_get_page_by_title( 'Login' ) : get_page_by_title( 'Login' );
$default_login = array();
if(isset($login_page_default) && !empty($login_page_default)){
	$default_login = $login_page_default;
}elseif (!empty($login_page)){
	$default_login = $login_page->ID;
}

$login_custom = woffice_get_settings_option('login_custom');
$login_custom_default = ($login_custom) ? $login_custom : false;

$login_background_color = woffice_get_settings_option('login_background_color');
$login_background_color = ($login_background_color) ? $login_background_color : "#444";

$login_layout = woffice_get_settings_option('login_layout');
$login_layout = ($login_layout) ? $login_layout : "layout-1";

$login_background_image = woffice_get_settings_option('login_background_image');
$login_background_image_url = '';
$login_background_image_attachment_id = '';
if(isset($login_background_image['url']) && !empty($login_background_image['url']) && isset($login_background_image['attachment_id']) && !empty($login_background_image['attachment_id'])){
	$login_background_image_url = $login_background_image['url'];
	$login_background_image_attachment_id = $login_background_image['attachment_id'];
}

$login_background_opacity = woffice_get_settings_option('login_background_opacity');
$login_logo_image = woffice_get_settings_option('login_logo_image');
$login_logo_image_url = '';
$login_logo_image_attachment_id = '';
if(isset($login_logo_image['url']) && !empty($login_logo_image['url']) && isset($login_logo_image['attachment_id']) && !empty($login_logo_image['attachment_id'])){
	$login_logo_image_url = $login_logo_image['url'];
	$login_logo_image_attachment_id = $login_logo_image['attachment_id'];
}


$login_logo_image_width = woffice_get_settings_option('login_logo_image_width');
$login_revslider = woffice_get_settings_option('login_revslider');

$login_wordpress = woffice_unyson_switch_to_bool(woffice_get_settings_option('login_wordpress'));
$login_wordpress_default = (isset($login_wordpress)) ? $login_wordpress : false;

$login_rest_password = woffice_unyson_switch_to_bool(woffice_get_settings_option('login_rest_password'));
$login_rest_password_default = (isset($login_rest_password)) ? $login_rest_password : false;

 $aft_login = woffice_get_settings_option('aft_login');
 $aft_login_default = (isset($aft_login)) ? $aft_login : 'home';

 $custom_redirect_url = woffice_get_settings_option('custom_redirect_url');

$template_dir_url = get_template_directory_uri();

Redux::set_section(
	$opt_name,
	array(
		'title'      => esc_html__( 'Login Options', 'woffice' ),
		'id'         => 'login-register-login_options',
		'desc'       => esc_html__( 'For full documentation on this, visit: ', 'woffice' ) . '<a href="https://docs.woffice.io/" target="_blank">'.esc_html__('Woffice documentation','woffice').'</a>',
		'subsection' => true,

		'fields'     => array(
			array(
		        'id'       => 'login_custom',
		        'type'     => 'switch',
		        'title'    => esc_html__('Custom Login Page', 'woffice'),
		        'desc'     => esc_html__('That is going to replace the login page from Wordpress with the new one from Woffice -> IMPORTANT! The page as to be named LOGIN please.', 'woffice'),
		        'default'  => $login_custom_default,
		    ),
			array(
				'id'       => 'login_layout',
				'type'     => 'image_select',
            	'title'    => esc_html__( 'Login Page Layout', 'woffice' ),
				'presets'    => false,
				'options'  => array(
                    'layout-1' => array(
						'alt' => 'layout-1',
						'img' => $template_dir_url .'/images/login-left.jpg',
					),
					'layout-loginright' => array(
						'alt' => 'layout-loginright',
						'img' => $template_dir_url .'/images/login-right.jpg',
					),
                    'layout-2' => array(
						'alt' => 'layout-2',
						'img' => $template_dir_url .'/images/login-center.jpg',
					)
				),
				'default'  => $login_layout,
				'validate' => 'not_empty'
			),
			array(
				'id'       => 'login_page',
				'type'     => 'select',
				'title'    => esc_html__( 'Login page', 'woffice' ),
				'desc'     => esc_html__( 'This is the login page, it needs the Template fields to be set as "LOGIN".', 'woffice' ),
				'hint'  =>	array(
						        'content' => __('Just select the page\'s name here', 'woffice'),
						    ),
                'default' => $default_login,
                'data' => 'page'
			),
			array(
		        'id'            => 'login_text',
		        'type'          => 'editor',
		        'title'         => __('Welcome Message', 'woffice'), 
		        'subtitle'      => __('Above the login form.', 'woffice'),
		        'media_buttons' => false,
		        'editor_css' => '',
		        'args'   => array(
		            'teeny' => false,
					'wpautop' => false,
					'reinit' => false,
					'editor_css' => '',
					'quicktags'     => false,
		        )
		    ),
			array(
		        'id'       => 'login_background_color',
		        'type'     => 'color',
		        'title'    => __('Background color', 'woffice'),
		        'subtitle' => __('This is the background color and the image will be over it.','woffice'),
		        'default'  => $login_background_color,
		        'validate' => 'color',
		    ),
		    array(
				'id'           => 'login_background_image',
				'type'         => 'media',
				'url'          => true,
				'title'        => esc_html__( 'Background Image', 'woffice' ),
				'desc'     	   => esc_html__( 'Large Image on fullscreen.', 'woffice' ),
				'compiler'     => 'true',
				'preview_size' => 'thumbnail',
				'default'  => array(
                    'url'=> $login_background_image_url,
                    'id'=> $login_background_image_attachment_id
                ),
			),
			 array(
		        'id' => 'login_background_opacity',
		        'type' => 'slider',
		        'title' => __( 'Image Opacity', 'woffice' ),
		        "default" => $login_background_opacity,
		        "min" => 0,
		        "step" => .1,
		        "max" => 1,
		         'resolution' => 0.1,
		        'display_value' => 'label'
		    ),
			array(
				'id'           => 'login_logo_image',
				'type'         => 'media',
				'url'          => true,
				'title'        => esc_html__( 'Logo Image', 'woffice' ),
				'desc'     	   => esc_html__( 'Just your logo as a PNG file', 'woffice' ),
				'preview_size' => 'thumbnail',
				'default'  => array(
                    'url'=> $login_logo_image_url,
                    'id'=> $login_logo_image_attachment_id
                ),
			),
			array(
		        'id'    => 'login_logo_image_width',   
		        'type'  => 'text',
		        'value' => $login_logo_image_width,
		        'title' => __( 'Logo Width', 'woffice' ),
		    ),
		    array(
		        'id'    => 'login_revslider',   
		        'type'  => 'text',
		        'value' => $login_revslider,
		        'title' => __( 'Revolution Slider ID', 'woffice' ),
		        'desc'  => __('Optional Revolution\'s slider ID','woffice'),
		    ), 
			array(
		        'id'       => 'login_wordpress',
		        'type'     => 'switch',
		        'title'    => esc_html__('Show Wordpress Logo', 'woffice'),
		        'default'  => $login_wordpress_default,
		    ),
		    array(
		        'id'       => 'login_rest_password',
		        'type'     => 'switch',
		        'title'    => esc_html__('Show reset password link', 'woffice'),
		        'default'  => $login_rest_password_default,
		        'desc' => __('If you select On, we will add a link to the "reset password" Wordpress page, so the visitor can get a new password.','woffice'),
		    ),
		    array(
				'id'       => 'aft_login',
				'type'     => 'select',
				'title'    => esc_html__( 'After login ?', 'woffice' ),
				'options' => array(
				        	'custom' => __('Custom URL', 'woffice'),
				        	'previous' => __('Previous URL', 'woffice'),
				        	'home' => __('Homepage', 'woffice'),
						),
                'default' => $aft_login_default
            ),
		     array(
		        'id'    => 'custom_redirect_url',   
		        'type'  => 'text',
		        'value' => $custom_redirect_url,
		        'title' => __( 'Custom URL', 'woffice' ),
		        'desc'  => __('If you select Custom URL above.','woffice'),
		    ), 
		),
	)
);
