<?php
/**
 * Redux Framework image select config.
 * For full documentation, please visit: http://devs.redux.io/
 *
 * @package Redux Framework
 */

defined( 'ABSPATH' ) || exit;
$plugins_url = plugins_url();

Redux::set_section(
	$opt_name,
	array(
		'title'      => esc_html__( 'Menu Layout', 'woffice' ),
		'id'         => 'select-menu_select',
		'desc'       => esc_html__( 'For full documentation on this, visit: ', 'woffice' ) . '<a href="https://docs.woffice.io/" target="_blank">'.esc_html__('Woffice documentation','woffice').'</a>',
		'subsection' => true,
		'fields'     => array(
			array(
				'id'       => 'show_left_on_hover',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show on hover', 'woffice' ),
				'desc'     => esc_html__( 'Show Menu when use hover on icon', 'woffice' ),
                'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => 'off',
				'required' => array('menu_layout','equals','left')
			),
			array(
				'id'       => 'show_top_on_click',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show on Click', 'woffice' ),
				'desc'     => esc_html__( 'Show Menu when use click on icon', 'woffice' ),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => 'off',
				'required' => array('menu_layout','equals','top')
			),
			array(
				'id'       => 'menu_layout',
				'type'     => 'image_select',
            	'title'    => esc_html__( 'Select Layout', 'woffice' ),
				'presets'    => false,
				'options'  => array(
					'left' => array(
						'title' => 'Left',
						'alt' => 'Left',
						'img' => $plugins_url .'/woffice-core/theme-options/options/img/left.png',
					),
                    'top' => array(
						'title' => 'Top',
						'alt' => 'Top',
						'img' => $plugins_url .'/woffice-core/theme-options/options/img/top.png',
					),
				),
				'default'  => 'left',
			),
			array(
				'id'       => 'enable_menu_icons',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable Woffice Menu Icons', 'woffice' ),
				'desc'     => esc_html__( 'Show icons next to menu text labels for better visual association.', 'woffice' ),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => false,
			),
			array(
				'id'       => 'left_menu_height',
				'type'     => 'switch',
				'title'    => esc_html__( 'Height of left menu', 'woffice' ),
				'desc'     => esc_html__( 'Show left menu as fixed height or full height', 'woffice' ),
				'on'       => esc_html__('Full Height','woffice'),
				'off'      => esc_html__('Fixed','woffice'),
				'required' => array('menu_layout','equals', 'left'),
				'default'  => false,
			),
			array(
				'id'       => 'enable_menu_style',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable Menu Color', 'woffice' ),
				'desc'     => esc_html__( 'Enable custom menu Color', 'woffice' ),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => false,
			),
			array(
				'id'       => 'section-menu-style-start',
				'type'     => 'section',
                'title'    => esc_html__( 'Menu Colors', 'woffice' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
				'required' => array('enable_menu_style','equals', true)
			),
			array(
                'id'       => 'menu_background',
                'type'     => 'color',
				'title'    => esc_html__( 'Menu background', 'woffice' ),
                'desc'    => esc_html__( 'The background color of the menu', 'woffice' ),
                'default'  => '',
                'transparent' => true,
                'color_alpha' => true,
				'required' => array('enable_menu_style','equals', true)
            ),
			array(
                'id'       => 'menu_text_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Menu Text', 'woffice' ),
				'desc'    => esc_html__( 'Used for the normal text color', 'woffice' ),
                'default'  => '',
                'transparent' => true,
                'color_alpha' => true,
				'required' => array('enable_menu_style','equals', true)
            ),
			array(
                'id'       => 'menu_hover_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Menu Background Hover/Active', 'woffice' ),
				'desc'    => esc_html__( 'The background color of the Menu Hover/Active', 'woffice' ),
                'default'  => '',
                'transparent' => true,
                'color_alpha' => true,
				'required' => array('enable_menu_style','equals', true)
            ),
			array(
                'id'       => 'menu_hover_text_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Menu Hover/Active text', 'woffice' ),
				'desc'    => esc_html__( 'The Text color on menu hover or active', 'woffice' ),
                'default'  => '',
                'transparent' => true,
                'color_alpha' => true,
				'required' => array('enable_menu_style','equals', true)
            ),
			array(
                'id'       => 'submenu_background',
                'type'     => 'color',
                'title'    => esc_html__( 'Submenu Background', 'woffice' ),
				'desc'    => esc_html__( 'The background color of the submenu', 'woffice' ),
                'default'  => '',
                'transparent' => true,
                'color_alpha' => true,
				'required' => array('enable_menu_style','equals', true)
            ),
			array(
                'id'       => 'submenu_hover_bg_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Submenu Hover/Active Background', 'woffice' ),
				'desc'    => esc_html__( 'Submenu Background color Hover/Active when menu layout is top.', 'woffice' ),
                'default'  => '',
                'transparent' => true,
                'color_alpha' => true,
				'required' => array(
					array('enable_menu_style','equals', true),
					array('menu_layout','equals', 'top')
				)
            ),
			array(
                'id'       => 'submenu_text_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Submenu Text', 'woffice' ),
				'desc'    => esc_html__( 'Normal Text color of the submenu', 'woffice' ),
                'default'  => '',
                'transparent' => true,
                'color_alpha' => true,
				'required' => array('enable_menu_style','equals', true)
            ),
			array(
                'id'       => 'submenu_hover_text_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Submenu Hover/Active Text', 'woffice' ),
				'desc'    => esc_html__( 'submenu Hover/Active', 'woffice' ),
                'default'  => '',
                'transparent' => true,
                'color_alpha' => true,
				'required' => array('enable_menu_style','equals', true)
            ),
			array(
				'id'       => 'section-menu-style-end',
				'type'     => 'section',
                'indent'   => false,
				'required' => array('enable_menu_style','equals', true)
			),
			array(
				'id'       => 'enable_menu_typography',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable Menu Typography', 'woffice' ),
				'desc'     => esc_html__( 'Enable custom menu Color', 'woffice' ),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => false,
			),
			array(
				'id'       => 'section-menu-typography-start',
				'type'     => 'section',
                'title'    => esc_html__( 'Menu Typography', 'woffice' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
				'required' => array('enable_menu_typography','equals', true)
			),
			array(
				'id'                => 'menu_font_desktop',
				'type'              => 'typography',
				'title'             => esc_html__( 'Menu font Desktop', 'woffice' ),
				'subtitle'          => esc_html__( 'Main menu items', 'woffice' ),
				'google'            => true,
				'font_family_clear' => true,
                'color'             => false,
                'text-align'        => false,
                'subsets'           => false,
                'default'           => array(
					'font-size'   => '',
					'font-family' => '',
					'font-weight' => '',
				),
				'required' => array('enable_menu_typography','equals', true)
			),
			array(
				'id'                => 'menu_font_tablet',
				'type'              => 'typography',
				'title'             => esc_html__( 'Menu font Tablet', 'woffice' ),
				'subtitle'          => esc_html__( 'Main menu items.', 'woffice' ),
				'google'            => true,
				'font_family_clear' => true,
                'color'             => false,
                'text-align'        => false,
                'subsets'           => false,
                'default'           => array(
					'font-size'   => '',
					'font-family' => '',
					'font-weight' => '',
				),
				'required' => array('enable_menu_typography','equals', true)
			),
			array(
				'id'                => 'menu_font_mobile',
				'type'              => 'typography',
				'title'             => esc_html__( 'Menu font Mobile', 'woffice' ),
				'subtitle'          => esc_html__( 'Main menu items', 'woffice' ),
				'google'            => true,
				'font_family_clear' => true,
                'color'             => false,
                'text-align'        => false,
                'subsets'           => false,
                'default'           => array(
					'font-size'   => '',
					'font-family' => '',
					'font-weight' => '',
				),
				'required' => array('enable_menu_typography','equals', true)
			),
			array(
				'id'                => 'submenu_font_desktop',
				'type'              => 'typography',
				'title'             => esc_html__( 'SubMenu font Desktop', 'woffice' ),
				'subtitle'          => esc_html__( 'Sub-menu items.', 'woffice' ),
				'google'            => true,
				'font_family_clear' => true,
                'color'             => false,
                'text-align'        => false,
                'subsets'           => false,
                'default'           => array(
					'font-size'   => '',
					'font-family' => '',
					'font-weight' => '',
				),
				'required' => array('enable_menu_typography','equals', true)
			),
			array(
				'id'                => 'submenu_font_tablet',
				'type'              => 'typography',
				'title'             => esc_html__( 'Submenu font Tablet', 'woffice' ),
				'subtitle'          => esc_html__( 'Sub-menu items.', 'woffice' ),
				'google'            => true,
				'font_family_clear' => true,
                'color'             => false,
                'text-align'        => false,
                'subsets'           => false,
                'default'           => array(
					'font-size'   => '',
					'font-family' => '',
					'font-weight' => '',
				),
				'required' => array('enable_menu_typography','equals', true)
			),
			array(
				'id'                => 'submenu_font_mobile',
				'type'              => 'typography',
				'title'             => esc_html__( 'SubMenu font Mobile', 'woffice' ),
				'subtitle'          => esc_html__( 'Sub-menu items.', 'woffice' ),
				'google'            => true,
				'font_family_clear' => true,
                'color'             => false,
                'text-align'        => false,
                'subsets'           => false,
                'default'           => array(
					'font-size'   => '',
					'font-family' => '',
					'font-weight' => '',
				),
				'required' => array('enable_menu_typography','equals', true)
			),
			array(
				'id'       => 'section-menu-typography-end',
				'type'     => 'section',
                'indent'   => false,
				'required' => array('enable_menu_typography','equals', true)
			),
		),
	)
);
