<?php
// Exit if accessed directly.
defined('ABSPATH') || exit;

if (!class_exists('Redux_Metaboxes')) {
    return;
}

$post_id = isset($_GET['post']) ? $_GET['post'] : 0;

$event_title = get_post_meta($post_id, 'fw_option:woffice_event_title', true);
$woffice_event_date_start = get_post_meta($post_id, 'fw_option:woffice_event_date_start', true);
$woffice_event_date_end = get_post_meta($post_id, 'fw_option:woffice_event_date_end', true);
$woffice_event_repeat = get_post_meta($post_id, 'fw_option:woffice_event_repeat', true);
$woffice_event_repeat_date_end = get_post_meta($post_id, 'fw_option:woffice_event_repeat_date_end', true);
$woffice_event_color = get_post_meta($post_id, 'fw_option:woffice_event_color', true);
$woffice_event_visibility = get_post_meta($post_id, 'fw_option:woffice_event_visibility', true);
$woffice_event_description = get_post_meta($post_id, 'fw_option:woffice_event_description', true);
$woffice_event_location = get_post_meta($post_id, 'fw_option:woffice_event_location', true);
$woffice_event_link = get_post_meta($post_id, 'fw_option:woffice_event_link', true);

$user_id = get_current_user_id();

$visibility = array();
$event_create = function_exists('woffice_get_theming_option') ? woffice_get_theming_option('event_create') : '';

if (class_exists('Woffice_Frontend') && Woffice_Frontend::role_allowed($event_create)) {

    $args = array(
        'post_type' => 'project',
        'posts_per_page' => '-1',
    );

    $user_posts = get_posts($args);
    $project_options = array();
    foreach ($user_posts as $project) {
        if ($user_id && $user_id !== (int) $project->post_author) {
            $project_members = (function_exists('get_post_meta')) ? get_post_meta($project->ID,
                'project_members') : '';

            if (!empty($project_members) && !in_array($user_id, $project_members)) {
                continue;
            }
        }

        $project_options['project_' . $project->ID] = $project->post_title;
    }

    $visibility = array(
        'personal' => __('Personal', 'woffice'),
        'general' => __('General', 'woffice'),
        'Project' => $project_options,
        // 'Group' => $group_options,
    );
} else {
    $visibility = array(
        'personal' => __('Personal', 'woffice'),
    );
}
// $opt_name = 'woffice_evnt';
// Standard metabox.
Redux_Metaboxes::set_box(
    $opt_name,
    array(
        'id' => 'opt-woffice-event-meta',
        'title' => esc_html__('Woffice Event Settings', 'woffice'),
        'post_types' => array('woffice-event'),
        'position' => 'normal', // normal, advanced, side.
        'priority' => 'high', // high, core, default, low.
        'metaboxes_save_defaults' => true,
        'sections' => array(
            array(
                'id' => 'opt-divide-woffice-event-meta',
                'type' => 'divide',
            ),
            array(
                'icon_class' => 'icon-large',
                'icon' => 'el-icon-home',
                'title' => esc_html__('Event Settings', 'woffice'),
                'fields' => array(
                    array(
                        'id' => 'woffice_event_title',
                        'type' => 'text',
                        'title' => esc_html__('Title', 'woffice'),
                        'desc' => esc_html__('Set event name.', 'woffice'),
                        'default' => !empty($event_title) ? $event_title : '',
                    ),
                    array(
                        'id' => 'woffice_event_date_start',
                        'type' => 'datetime',
                        'title' => esc_html__('Event Starting Date', 'woffice'),
                        'desc' => esc_html__('Will be used to display this event in the calendar.', 'woffice'),
                        'default' => !empty($woffice_event_date_start) ? $woffice_event_date_start : '',
                        'date-format' => 'yy-mm-dd',
                        'time-format' => 'H:mm:s',
                    ),
                    array(
                        'id' => 'woffice_event_date_end',
                        'type' => 'datetime',
                        'title' => esc_html__('Event Ending Date', 'woffice'),
                        'desc' => esc_html__('Will be used to display this event in the calendar.', 'woffice'),
                        'default' => !empty($woffice_event_date_end) ? $woffice_event_date_end : '',
                        'date-format' => 'yy-mm-dd',
                        'time-format' => 'H:mm:s',
                    ),
                    array(
                        'id' => 'woffice_event_repeat',
                        'type' => 'select',
                        'title' => esc_html__('Repeat', 'woffice'),
                        'desc' => esc_html__('Select repeat type, Choose no if not repeatable event.', 'woffice'),
                        'options' => array(
                            'No' => esc_html__('No', 'woffice'),
                            'Daily' => esc_html__('Daily', 'woffice'),
                            'Weekly' => esc_html__('Weekly', 'woffice'),
                            'Monthly' => esc_html__('Monthly', 'woffice'),
                            'Yearly' => esc_html__('Yearly', 'woffice'),
                        ),
                        'default' => !empty($woffice_event_repeat) ? $woffice_event_repeat : 'No',
                    ),
                    array(
                        'id' => 'woffice_event_repeat_date_end',
                        'type' => 'datetime',
                        'title' => esc_html__('Repeat Ending Date', 'woffice'),
                        'desc' => esc_html__('Will be used to display this event in the calendar.', 'woffice'),
                        'default' => !empty($woffice_event_repeat_date_end) ? $woffice_event_repeat_date_end : '',
                        'date-format' => 'yy-mm-dd',
                        'time-format' => 'H:mm:s',
                    ),
                    array(
                        'id' => 'woffice_event_color',
                        'type' => 'select',
                        'title' => esc_html__('Event Color', 'woffice'),
                        'desc' => esc_html__('Event color in calendar.', 'woffice'),
                        'options' => array(
                            'default' => esc_html__('default', 'woffice'),
                            'blue' => esc_html__('blue', 'woffice'),
                            'orange' => esc_html__('orange', 'woffice'),
                            'red' => esc_html__('red', 'woffice'),
                            'green' => esc_html__('green', 'woffice'),
                            'grey' => esc_html__('grey', 'woffice'),
                            'light-blue' => esc_html__('light blue', 'woffice'),
                            'dark-blue' => esc_html__('dark blue', 'woffice'),
                            'fushia' => esc_html__('fushia', 'woffice'),
                            'brown' => esc_html__('brown', 'woffice'),
                            'black' => esc_html__('black', 'woffice'),
                            'light-grey' => esc_html__('light grey', 'woffice'),
                        ),
                        'default' => !empty($woffice_event_color) ? $woffice_event_color : 'default',
                    ),
                    array(
                        'id' => 'woffice_event_visibility',
                        'type' => 'select',
                        'title' => esc_html__('Event Visibility', 'woffice'),
                        'desc' => esc_html__('Set Event Visibility.', 'woffice'),
                        'options' => $visibility,
                        'default' => !empty($woffice_event_visibility) ? $woffice_event_visibility : 'general',
                    ),
                    array(
                        'id' => 'woffice_event_description',
                        'type' => 'textarea',
                        'title' => esc_html__('Description', 'woffice'),
                        'default' => !empty($woffice_event_description) ? $woffice_event_description : '',
                    ),
                    array(
                        'id' => 'woffice_event_location',
                        'type' => 'text',
                        'title' => esc_html__('Location', 'woffice'),
                        'desc' => esc_html__('Location of the event..', 'woffice'),
                        'default' => !empty($woffice_event_location) ? $woffice_event_location : '',
                    ),
                    array(
                        'id' => 'woffice_event_link',
                        'type' => 'text',
                        'title' => esc_html__('Event URL', 'woffice'),
                        'desc' => esc_html__('URL of the event..', 'woffice'),
                        'validate' => 'url',
                        'default' => !empty($woffice_event_link) ? $woffice_event_link : '',
                    ),
                ),
            ),
        ),
    ),
);
