<?php

/**
 * The file that defines the core plugin class
 *
 * A class definition that includes attributes and functions used across both the
 * public-facing side of the site and the admin area.
 *
 * @link       https://woffice.io
 * @since      1.0.0
 *
 * @package    Woffice_Credit_System
 * @subpackage Woffice_Credit_System/includes
 */

/**
 * The core plugin class.
 *
 * This is used to define internationalization, admin-specific hooks, and
 * public-facing site hooks.
 *
 * Also maintains the unique identifier of this plugin as well as the current
 * version of the plugin.
 *
 * @since      1.0.0
 * @package    Woffice_Credit_System
 * @subpackage Woffice_Credit_System/includes
 * @author     Woffice  <https://woffice.io>
 */
class Woffice_Credit_System {

	/**
	 * The loader that's responsible for maintaining and registering all hooks that power
	 * the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      Woffice_Credit_System_Loader    $loader    Maintains and registers all hooks for the plugin.
	 */
	protected $loader;

	/**
	 * The unique identifier of this plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $plugin_name    The string used to uniquely identify this plugin.
	 */
	protected $plugin_name;

	/**
	 * The current version of the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $version    The current version of the plugin.
	 */
	protected $version;

	/**
	 * Define the core functionality of the plugin.
	 *
	 * Set the plugin name and the plugin version that can be used throughout the plugin.
	 * Load the dependencies, define the locale, and set the hooks for the admin area and
	 * the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function __construct() {
		if ( defined( 'WOCS_CSAI_ITEM_VERSION' ) ) {
			$this->version = WOCS_CSAI_ITEM_VERSION;
		} else {
			$this->version = '1.0.0';
		}
		$this->plugin_name = 'woffice-credits';

		$this->load_dependencies();
		$this->set_locale();
		$this->define_public_hooks();
		$this->define_admin_constant();
		$this->run_plugin_updater();

	}

	/**
	 * Load the required dependencies for this plugin.
	 *
	 * Include the following files that make up the plugin:
	 *
	 * - Woffice_Credit_System_Loader. Orchestrates the hooks of the plugin.
	 * - Woffice_Credit_System_i18n. Defines internationalization functionality.
	 * - Woffice_Credit_System_Admin. Defines all hooks for the admin area.
	 * - Woffice_Credit_System_Public. Defines all hooks for the public side of the site.
	 *
	 * Create an instance of the loader which will be used to register the hooks
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function load_dependencies() {


		
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-admin-viewer.php';
		new Woffice_Credit_System_Admin_Viewer();

		/**
		 * The class responsible for orchestrating the actions and filters of the
		 * core plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-woffice-credit-system-loader.php';

		/**
		 * The class responsible for defining internationalization functionality
		 * of the plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-woffice-credit-system-i18n.php';

		/**
		 * The class responsible for defining all actions that occur in the public-facing
		 * side of the site.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/class-woffice-credit-system-public.php';

		/**
		 * The class responsible for defining all actions that occur in the public-facing
		 * side of the site.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/partials/class-woffice-credit-system-view.php';
		new Woffice_Credit_System_View();
		/**
		 * The class responsible for defining all actions that occur in the public-facing
		 * side of the site.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-woffice-credit-system-actions.php';
		new Woffice_Credit_System_Actions();

		$this->loader = new Woffice_Credit_System_Loader();

	}

	/**
	 * Define the locale for this plugin for internationalization.
	 *
	 * Uses the Woffice_Credit_System_i18n class in order to set the domain and to register the hook
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function set_locale() {

		$plugin_i18n = new Woffice_Credit_System_i18n();

		$this->loader->add_action( 'plugins_loaded', $plugin_i18n, 'load_plugin_textdomain' );

	}

	/**
	 * Define the locale for this plugin for internationalization.
	 *
	 * Uses the Woffice_Credit_System_i18n class in order to set the domain and to register the hook
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_admin_constant() {

		define('WOCS_CSAI_STORE_URL' , 'https://woffice.io/');
		define('WOCS_CSAI_EDD_AJAX' , true);
		define('WOCS_CSAI_SLUG' , 'WOCS_CSAI');
		define('WOCS_CSAI_ITEM_ID', 28197 );
		define('WOCS_CSAI_ITEM_VERSION', '1.0.8' );
		define('WOCS_CSAI_URL', 'https://woffice.io/wp-json/woffice_ai/v2/');

	}

	/**
	 * Register all of the hooks related to the public-facing functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_public_hooks() {

		$plugin_public = new Woffice_Credit_System_Public( $this->get_plugin_name(), $this->get_version() );

		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_styles' );
		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_scripts' );

	}

	/**
	 * Run the loader to execute all of the hooks with WordPress.
	 *
	 * @since    1.0.0
	 */
	public function run() {
		$this->loader->run();
	}

	/**
	 * The name of the plugin used to uniquely identify it within the context of
	 * WordPress and to define internationalization functionality.
	 *
	 * @since     1.0.0
	 * @return    string    The name of the plugin.
	 */
	public function get_plugin_name() {
		return $this->plugin_name;
	}

	/**
	 * The reference to the class that orchestrates the hooks with the plugin.
	 *
	 * @since     1.0.0
	 * @return    Woffice_Credit_System_Loader    Orchestrates the hooks of the plugin.
	 */
	public function get_loader() {
		return $this->loader;
	}

	/**
	 * Retrieve the version number of the plugin.
	 *
	 * @since     1.0.0
	 * @return    string    The version number of the plugin.
	 */
	public function get_version() {
		return $this->version;
	}

	public function run_plugin_updater() {

		if(!class_exists('Plugin_Item_Activator')) {
			require_once plugin_dir_path( dirname( __FILE__ ) ) . 'vendor/woffice-plugin-updater/class-woffice-license-updater.php' ;
		}

		if(!class_exists('EDD_SL_Plugin_Updater')) {
			require_once plugin_dir_path( dirname( __FILE__ ) ) . 'vendor/woffice-plugin-updater/class-edd-sl-updater.php';
		}

		$updater = new Plugin_Item_Activator();
		$updater->plugin_updater(WOCS_CSAI_SLUG,__FILE__);
	}

}
